package org.gcube.data.analysis.statisticalmanager.persistence;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Profile;
import org.gcube.common.resources.gcore.ServiceEndpoint.Property;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

//import com.rapidminer.operator.learner.igss.Result;

public class RuntimeResourceManager {

	private static GCUBELog logger = new GCUBELog(RuntimeResourceManager.class);

	private static final String RUNTIME_RESOURCE_DB = "StatisticalManagerDataBase";

	public static void initializeDataBase() throws Exception {

		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Name/text() eq '"
				+ RUNTIME_RESOURCE_DB + "'");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		Map<String, GCUBEScope> scopes = ServiceContext.getContext()
				.getInstance().getScopes();
		List<ServiceEndpoint> resources = null;
		for (Entry<String, GCUBEScope> scope : scopes.entrySet()) {

			ScopeProvider.instance.set(scope.getValue().toString());
			resources = client.submit(query);
			if (resources != null && !resources.isEmpty())
				break;

		}

		if (resources == null || resources.isEmpty())
			throw new StatisticalManagerException("Runtime resource "
					+ RUNTIME_RESOURCE_DB + " not found");

		ServiceEndpoint resource = resources.get(0);
		if (resource.profile().accessPoints() == null
				|| resource.profile().accessPoints().isEmpty())
			throw new StatisticalManagerException("Accesspoint in resource "
					+ RUNTIME_RESOURCE_DB + " not found");

		for (AccessPoint ap : resource.profile().accessPoints()) {

			logger.debug("Access point name " + ap.name());

			if (ap.name().equals("jdbc")) {

				logger.debug("URL jdbc  " + ap.address());
				logger.debug("User jdbc " + ap.username());
				logger.debug("Pass jdbc "
						+ StringEncrypter.getEncrypter().decrypt(ap.password()));

				DataBaseManager.initializeDataSource(ap.address(),
						ap.username(),
						StringEncrypter.getEncrypter().decrypt(ap.password()));
			}

			if (ap.name().equals("hibernate")) {
				logger.debug("URL hibernate  " + ap.address());
				logger.debug("User hibernate " + ap.username());
				logger.debug("Pass hibernate "
						+ StringEncrypter.getEncrypter().decrypt(ap.password()));

				HibernateManager.buildSessionFactory(ap.address(),
						ap.username(),
						StringEncrypter.getEncrypter().decrypt(ap.password()));

			}
		}
	}

	public static HashMap<String, String> getRRProfile(String runtimeResource)
			throws Exception {
		HashMap<String, String> rrParameter = new HashMap<String, String>();
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Name/text() eq '"
				+ runtimeResource + "'");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		Map<String, GCUBEScope> scopes = ServiceContext.getContext()
				.getInstance().getScopes();
		List<ServiceEndpoint> resources = null;
		for (Entry<String, GCUBEScope> scope : scopes.entrySet()) {

			ScopeProvider.instance.set(scope.getValue().toString());
			resources = client.submit(query);
			if (resources != null && !resources.isEmpty())
				break;

		}

		if (resources == null || resources.isEmpty())
			throw new StatisticalManagerException("Runtime resource "
					+ runtimeResource + " not found");

		ServiceEndpoint resource = resources.get(0);
		ScopeGroup<String> scopeGroup = resource.scopes();
		String sc= new String();
		for (String scope : scopeGroup) {
			sc += scope + ";";
		}
		rrParameter.put(runtimeResource + "." + "Scopes", sc);
		Profile profile = resource.profile();
		rrParameter.put(runtimeResource + "." + "Profile.Category",
				profile.category());
		Platform platform= profile.platform();
		
		rrParameter.put(runtimeResource + "." + "Profile.Platform.name", platform.name());
		rrParameter.put(runtimeResource + "." + "Profile.Platform.version", Integer.toString(platform.version()));
		rrParameter.put(runtimeResource + "." + "Profile.Platform.minorVersion",Integer.toString( platform.minorVersion()));
		rrParameter.put(runtimeResource + "." + "Profile.Platform.revisionVersion",Integer.toString( platform.revisionVersion()));
		rrParameter.put(runtimeResource + "." + "Profile.Platform.buildVersion",Integer.toString( platform.buildVersion()));

		org.gcube.common.resources.gcore.ServiceEndpoint.Runtime runtime= profile.runtime();
		
		rrParameter.put(runtimeResource + "." + "Profile.Runtime.hostedOn", runtime.hostedOn());
		rrParameter.put(runtimeResource + "." + "Profile.Runtime.status", runtime.status());
		rrParameter.put(runtimeResource + "." + "Profile.Runtime.ghnId", runtime.ghnId());

		if (profile.accessPoints() != null) {
			Group<AccessPoint> accessPoints = profile.accessPoints();
			for (AccessPoint accessPoint : accessPoints) {
				rrParameter.put(runtimeResource + "."
						+ "AccessPoint.Description", accessPoint.description());
				rrParameter.put(runtimeResource + "." + "AccessPoint.Address",
						accessPoint.address());
				rrParameter.put(
						runtimeResource + "." + "AccessPoint.Password",
						StringEncrypter.getEncrypter().decrypt(
								accessPoint.password()));
				rrParameter.put(runtimeResource + "." + "AccessPoint.Username",
						accessPoint.username());

				Map<String, Property> properties = accessPoint.propertyMap();
				for (Map.Entry<String, Property> entry : properties.entrySet()) {
					String propertyName = runtimeResource + "."
							+ entry.getKey().toString();
					String propertyVal = entry.getValue().toString();
					logger.debug("property:" + propertyName + ";" + propertyVal);

					rrParameter.put(propertyName, propertyVal);
				}
				break;
			}
		}
		else				
			logger.debug("access point null" );

		return rrParameter;
	}

	public static Group<AccessPoint> getRRAccessPoint(String runtimeResource)
			throws Exception {

		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Name/text() eq '"
				+ runtimeResource + "'");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		Map<String, GCUBEScope> scopes = ServiceContext.getContext()
				.getInstance().getScopes();
		List<ServiceEndpoint> resources = null;
		for (Entry<String, GCUBEScope> scope : scopes.entrySet()) {

			ScopeProvider.instance.set(scope.getValue().toString());
			resources = client.submit(query);
			if (resources != null && !resources.isEmpty())
				break;

		}

		if (resources == null || resources.isEmpty())
			throw new StatisticalManagerException("Runtime resource "
					+ runtimeResource + " not found");

		ServiceEndpoint resource = resources.get(0);
		if (resource.profile().accessPoints() == null
				|| resource.profile().accessPoints().isEmpty())
			throw new StatisticalManagerException("Accesspoint in resource "
					+ runtimeResource + " not found");

		return resource.profile().accessPoints();
	}

}
