package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;

public class CSVLineProcessorOcc extends CSVAbstractLineProcessor {

	private boolean toContinue = true;
	public ArrayList<ArrayList<String>> firstColumns = new ArrayList<ArrayList<String>>();
	private boolean stop = true;
	private int count = 0;
	private File file;
	int maxIteration = 10;
	private static GCUBELog logger = new GCUBELog(
			CSVLineProcessorOcc.class);

	ArrayList<String> types;

	public CSVLineProcessorOcc(String separator) throws IOException {
		super(separator);

		file = File.createTempFile("Occ", "csv");
		// TODO Auto-generated constructor stub
	}

	@Override
	public boolean continueProcessing() {
		return toContinue;
	}

	

	@Override
	public void processDataLine(int arg0, List<String> fields) {

		super.processDataLine(arg0, fields);
		// printArray(fields);
		if (count >= maxIteration) {
			stop = false;
		} else {

			if (fields != null) {
				ArrayList<String> ar = new ArrayList<String>(fields);
				// printArray(ar);
				String fieldValue = ar.get(0);
				List<String> elements = null;

				// try {
				// elements = Transformations.parseCVSString(fieldValue,
				// separator);
				// } catch (Exception e) {
				// elements = new ArrayList<String>();
				// }
				if (separator.equals(","))
					elements = fields;
				else
					elements = Arrays.asList(fieldValue.split(separator));

				// printArray(elements);
				int ncolumns = elements.size();
				// int ncolumns = fields.size();
				logger.debug("number of columns are" + ncolumns);
				for (int i = 0; i < ncolumns; i++) {
					logger.debug("i: " + i);
					String element = elements.get(i);
					// String element = fields.get(i);
					logger.debug("element :" + element);
					logger.debug("count " + count);

					if (i >= firstColumns.size()) {
						ArrayList<String> newer = new ArrayList<String>();
						newer.add(element);
						firstColumns.add(newer);

					} else {
						firstColumns.get(i).add(element);
						// firstColumns.get(i).set(count, element );
					}
					logger.debug("in the column " + i + "put element" + element);
				}

			}

			count++;
		}

	}

	// @Override
	// public void processDataLine(int arg0, List<String> fields) {
	//
	// try {
	// FileWriter fstream = new FileWriter(file, true);
	// BufferedWriter out = new BufferedWriter(fstream);
	// for (int i = 0; i < fields.size(); i++) {
	// String fieldValue = fields.get(i);
	//
	// if (separator.equals(",")) {
	// if (i == getIndexTime())
	// sqlTypes.add("timestamp without time zone");
	// else {
	//
	// String sqlType = getSQLType(fieldValue);
	// sqlTypes.add(sqlType);
	// }
	//
	// if (i == getIndexTime()) {
	//
	// Calendar calendar = DateGuesser.convertDate(fieldValue);
	// SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
	// String timeValue = sdf.format(calendar.getTime());
	//
	// timeValue = (i == fields.size() - 1)?timeValue:timeValue + ",";
	// out.write(timeValue);
	//
	// } else {
	// String cleanedValue = (fieldValue.contains(","))?"\"" + fieldValue +
	// "\"":fieldValue;
	// cleanedValue = (i == fields.size() - 1)?cleanedValue:cleanedValue + ",";
	// out.write(cleanedValue);
	// }
	// } else {
	// int j = 0;
	// for(String value : fieldValue.split(separator)) {
	// if (j == getIndexTime())
	// sqlTypes.add("timestamp without time zone");
	// else {
	// String sqlType = getSQLType(value);
	// sqlTypes.add(sqlType);
	// j++;
	// }
	// out.write(fieldValue + ",");
	// }
	// }
	// }
	// out.write("\n");
	// out.close();
	// } catch (IOException e) {
	// // TODO Auto-generated catch block
	// e.printStackTrace();
	// }
	//
	// }

	private void printArray(List<String> a) {
		for (String ar : a) {
			logger.debug(ar);
			logger.debug("****");
		}
	}

	public void getWellFormaFile(File f) throws IOException {
		FileWriter fstream = new FileWriter(file, true);
		BufferedWriter out = new BufferedWriter(fstream);
		FileReader read = new FileReader(f);
		BufferedReader bufferReader = new BufferedReader(read);
		//bufferReader.readLine();
		// elements=Transformations.parseCVSString(fieldValue,
		// separator);
		String row = bufferReader.readLine();
		String formatedRow = formatRowWithText(row, separator);
		while (formatedRow != null) {

			String[] fields = formatedRow.split(separator);
			for (int i = 0; i < fields.length; i++) {
				String fieldValue = fields[i];
				//System.out.println("fieldValue" + fieldValue);

			
					String cleanedValue = (fieldValue.contains(",")) ? "\""
							+ fieldValue + "\"" : fieldValue;

					logger.debug("first clean: " + cleanedValue);
					cleanedValue = (i == fields.length - 1) ? cleanedValue
							: cleanedValue + separator;

					logger.debug(cleanedValue);
					out.write(cleanedValue);
				

			}
			out.write("\n");
			row = bufferReader.readLine();
			if(row!=null)
			{
				formatedRow = formatRowWithText(row, separator);
			}else
				formatedRow=null;

		}

		out.close();

	}

	// public String formatRowWithText(String row)
	// {
	// int indexFrom=0;
	// int indexChar=0;
	// int pair=0;
	// String result;
	// while (indexChar>=0)
	// {
	// indexChar=row.indexOf("\"", indexFrom);
	// if(indexChar>=0)
	// {
	// pair++;
	// indexFrom=indexChar;
	// }
	// if()
	//
	// }
	// }

	public static String getSqlType(ArrayList<String> values) {

		String className = DataTypeRecognizer.guessType(values);
		String sqlType = null;
		if (String.class.getName().equals(className)) {
			sqlType = "varchar";
		}
		if (Boolean.class.getName().equals(className)) {
			sqlType = "boolean";
		}

		if (BigDecimal.class.getName().equals(className)) {
			sqlType = "double precision";
		}
		return sqlType;
	}

	private String getSQLType(String value) {

		String sqlType = null;
		ArrayList<String> values = new ArrayList<String>();
		values.add(value);

		String className = DataTypeRecognizer.guessType(values);

		if (String.class.getName().equals(className)) {
			sqlType = "varchar";
		}
		if (Boolean.class.getName().equals(className)) {
			sqlType = "boolean";
		}

		if (BigDecimal.class.getName().equals(className)) {
			sqlType = "double precision";
		}

		return sqlType;
	}

	

	public File getFile() {
		return file;
	}

	public  String formatRowWithText(String row, String separator) {
		int indexFrom = 0;
		int indexChar = 0;
		int pair = 0;
		String result = new String();
		int i = 0;
		int lastPositiveIndex = 0;
		while (indexChar >= 0) {
			if (i == 0) {
				if (row.toCharArray()[0] == '\"') 
					indexChar = 0;
				else
					indexChar = row.indexOf("\"", indexFrom + 1);
					

			} else
				indexChar = row.indexOf("\"", indexFrom + 1);

			if (indexChar >= 0) {
				pair++;

				if (pair % 2 == 0) {

					String sub = row.substring(indexFrom, indexChar);

					if (sub.contains(separator)) {

						if (separator == ",") {

							sub = sub.replace(";", " ");


							sub = sub.replace(separator, ";");

						} else {

							sub = sub.replace(",", " ");


							sub = sub.replaceAll(separator, ",");

						}

//						System.out.println("sub senza separato " + sub);

					}
					result = result + sub;
//					System.out.println("string concat " + result);

				} else {
//					System.out.println("sub non pair");

					result = result + row.substring(indexFrom, indexChar);
//					System.out.println("string concat " + result);

				}
				lastPositiveIndex = indexChar;

			} else {
				if (i == 0) {
//					System.out.println("non c è apici ");

					return row;
				}
			}
			indexFrom = indexChar;

			i++;
		}
		result = result + row.substring(lastPositiveIndex, row.length());
		return result;

	}


}
