/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;

public class AlgorithmDescriptor {
    private String name;
    private AlgorithmCategory category;
    private Map<String, StatisticalType> parameters;
    private String description;
    private StatisticalType output = null;
    private Boolean dinamycallyLoaded = false;
    private HashSet<String> userPerspectiveCategory = new HashSet();

    public AlgorithmDescriptor(String name, AlgorithmCategory category, List<StatisticalType> parameters, String description, StatisticalType output) {
        this.name = name;
        this.category = category;
        this.parameters = new HashMap<String, StatisticalType>();
        for (StatisticalType parameter : parameters) {
            this.parameters.put(parameter.getName(), parameter);
        }
        this.description = description;
        this.output = output;
    }

    public AlgorithmDescriptor(String name, AlgorithmCategory category) {
        this.name = name;
        this.category = category;
        this.dinamycallyLoaded = true;
    }

    public AlgorithmDescriptor(AlgorithmDescriptor toCopy) {
        this.name = new String(toCopy.getName());
        this.category = toCopy.getCategory();
        this.parameters = new HashMap<String, StatisticalType>(toCopy.getParameters());
        this.description = new String(toCopy.getDescription());
        this.output = toCopy.hasDynamicOutput() ? null : new StatisticalType(toCopy.getOutput().getName(), toCopy.getOutput().getDescription());
        this.userPerspectiveCategory = toCopy.getUserPerspectiveCategory();
    }

    public boolean hasDynamicOutput() {
        return this.output == null;
    }

    public StatisticalType getOutput() {
        return this.output;
    }

    public Boolean isDinamycallyLoaded() {
        return this.dinamycallyLoaded;
    }

    public void setDinamycallyLoaded(Boolean dinamycallyLoaded) {
        this.dinamycallyLoaded = dinamycallyLoaded;
    }

    public void setOutput(StatisticalType output) {
        this.output = output;
    }

    public HashSet<String> getUserPerspectiveCategory() {
        return this.userPerspectiveCategory;
    }

    public void setUserPerspectiveCategory(HashSet<String> userPerspectiveCategory) {
        this.userPerspectiveCategory = userPerspectiveCategory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AlgorithmCategory getCategory() {
        return this.category;
    }

    public void setCategory(AlgorithmCategory category) {
        this.category = category;
    }

    public Map<String, StatisticalType> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, StatisticalType> parameters) {
        this.parameters = parameters;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlgorithmDescriptor other = (AlgorithmDescriptor)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public SMAlgorithm asSMAlgorithm() {
        return new SMAlgorithm(this.category.name(), this.description, this.name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlgorithmDescriptor [name=");
        builder.append(this.name);
        builder.append(", category=");
        builder.append((Object)this.category);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", output=");
        builder.append(this.output);
        builder.append(", dinamycallyLoaded=");
        builder.append(this.dinamycallyLoaded);
        builder.append(", userPerspectiveCategory=");
        builder.append(this.userPerspectiveCategory);
        builder.append("]");
        return builder.toString();
    }

    public static ArrayList<SMAlgorithm> asList(Collection<AlgorithmDescriptor> toTranslate) {
        ArrayList<SMAlgorithm> toReturn = new ArrayList<SMAlgorithm>();
        for (AlgorithmDescriptor descriptor : toTranslate) {
            toReturn.add(descriptor.asSMAlgorithm());
        }
        return toReturn;
    }

    public void update(AlgorithmDescriptor updated) {
        this.setDescription(updated.getDescription());
        if (updated.getParameters() != null) {
            this.setParameters(updated.getParameters());
        }
        if (updated.getOutput() != null) {
            this.setOutput(updated.getOutput());
        }
    }
}

