/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.is;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datapublishing.sdmx.model.TableAssociationResource;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISDataWriter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TableAssociationResource resource;
    private final boolean update;

    public ISDataWriter(TableAssociationResource resource) {
        this(resource, true);
    }

    private ISDataWriter(TableAssociationResource resource, boolean update) {
        this.resource = resource;
        this.update = update;
    }

    public ISDataWriter() {
        this(new TableAssociationResource(), false);
    }

    public void addAssociation(String flowID, String tabularResourceID, String tableID, String timeDimension, String primaryMeasure) {
        this.resource.addAssociation(flowID, tabularResourceID, tableID, timeDimension, primaryMeasure);
    }

    public void removeAssociation(String flowID) {
        this.resource.removeAssociation(flowID);
    }

    public boolean commit() {
        this.logger.debug("Commit new value on information system");
        RegistryPublisher rp = RegistryPublisherFactory.create();
        GenericResource response = null;
        if (this.update) {
            this.logger.debug("Updating IS...");
            response = (GenericResource)rp.update((Resource)this.resource.getGenericResurce());
        } else {
            this.logger.debug("Creating new resource");
            response = (GenericResource)rp.create((Resource)this.resource.getGenericResurce());
        }
        this.logger.debug("Response " + response);
        return response != null;
    }

    public static void main(String[] args) {
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
        SecurityTokenProvider.instance.set("adb146d7-1b6d-43ac-9c9a-d3c7187516c8-98187548");
        ISDataWriter dataWriter = new ISDataWriter();
        dataWriter.addAssociation("ENG.NEW_DS_DIVISION_dataFlow.79.0", "347", "6415", "329e4178-18b7-4fef-934a-62f3b6baa85b", "29cf2981-9d65-4c50-b71a-7537938d23e8");
        System.out.println(dataWriter.commit());
    }
}

