package org.gcube.data.analysis.tabulardata.cube.data;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.Geometry;
import org.gcube.data.analysis.tabulardata.model.datatype.Numeric;
import org.gcube.data.analysis.tabulardata.model.datatype.Text;
import org.gcube.data.analysis.tabulardata.model.datatype.geometry.GeometryType;

public class SQLTypeMapper {
	
	public static String getColumnSQLType(DataType type) {
		switch (type.getDataType()) {
		case BOOLEAN:
			return "boolean";
		case DATE:
			return "date";
		case GEOMETRY:
			Geometry geometryType = (Geometry) type;
			return String.format("geometry(%1$s,%2$s)", generateGeometryTypeString(geometryType),
					geometryType.getSrid());
		case INTEGER:
			return "integer";
		case NUMERIC:
			Numeric numericType = (Numeric) type;
			if (numericType.hasPrecision() && numericType.hasScale()) {
				return String.format("numeric(%1$s,%2$s)", numericType.getPrecision(), numericType.getScale());
			}
			if (numericType.hasPrecision()) {
				return String.format("numeric(%1$s)", numericType.getPrecision());
			}
			return "numeric";
		case TEXT:
			Text textType = (Text) type;
			return String.format("varchar(%1$s)", textType.getLenght());
		case TIME:
			return "time";
		case TIMESTAMP:
			return "timestamp";
		default:
			throw new RuntimeException("Don't know how to translate type " + type + " into a SQL type.");
		}
	}
	
	private static String generateGeometryTypeString(Geometry geometryType) {
		if (geometryType.getGeometryType() != GeometryType.GEOMETRY && geometryType.getDimensions() <= 2) {
			return geometryType.getGeometryType().toString();
		} else
			return geometryType.getGeometryType().toString() + "M";
	}

}
