/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.data;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.data.connection.admin.Admin;
import org.gcube.data.analysis.tabulardata.cube.data.connection.unprivileged.Unprivileged;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.mapping.SQLModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Default
@Singleton
public class SQLDatabaseWrangler
implements DatabaseWrangler {
    private final String DEFAULT_SCHEMA_NAME = "public";
    private static Logger log = LoggerFactory.getLogger(SQLDatabaseWrangler.class);
    private DatabaseConnectionProvider adminConnectionProvider;
    private DatabaseConnectionProvider unprivilegedConnectionProvider;
    private SQLModelMapper sqlModelMapper;

    @Inject
    public SQLDatabaseWrangler(@Admin DatabaseConnectionProvider adminConnectionProvider, @Unprivileged DatabaseConnectionProvider unprivilegedConnectionProvider, SQLModelMapper sqlModelMapper) {
        this.adminConnectionProvider = adminConnectionProvider;
        this.unprivilegedConnectionProvider = unprivilegedConnectionProvider;
        this.sqlModelMapper = sqlModelMapper;
    }

    @Override
    public String createTable() {
        return this.createTable(false);
    }

    @Override
    public String createTable(boolean unsafe) {
        String tableName = this.generateTableName();
        String query = this.generateCreateTableQuery(tableName, unsafe);
        query = query + this.generateUserAccountGrantQuery(tableName);
        query = query + this.generateUserAccountGrantQuery(tableName + "_id_seq");
        this.executeQuery(query);
        return tableName;
    }

    private String generateCreateTableQuery(String tableName, boolean unlogged) {
        if (unlogged) {
            return String.format("CREATE UNLOGGED TABLE %1$s ( id serial );", tableName);
        }
        return String.format("CREATE TABLE %1$s ( id serial );", tableName);
    }

    @Override
    public void removeTable(String tableName) {
        String query = this.generateDropTableQuery(tableName);
        this.executeQuery(query);
    }

    private String generateDropTableQuery(String tableName) {
        return String.format("DROP TABLE %1$s;", tableName);
    }

    @Override
    public String cloneTable(String tableName, boolean withData, boolean unsafe) {
        String newTableName = this.generateTableName();
        String query = this.generateCloneTableQuery(newTableName, tableName, withData, unsafe);
        query = query + this.generateUserAccountGrantQuery(newTableName);
        query = query + this.generateUserAccountGrantQuery(newTableName + "_id_seq");
        this.executeQuery(query);
        return newTableName;
    }

    private String generateCloneTableQuery(String newTableName, String tableToCloneName, boolean withData, boolean unsafe) {
        StringBuilder sb = new StringBuilder();
        String unlogged = "";
        if (unsafe) {
            unlogged = "UNLOGGED";
        }
        String data = "";
        data = withData ? "WITH DATA" : "WITH NO DATA";
        sb.append(String.format("CREATE %1$s TABLE %2$s AS TABLE %3$s %4$s;", unlogged, newTableName, tableToCloneName, data));
        sb.append(String.format("CREATE SEQUENCE %1$s_id_seq OWNED BY %1$s.id;", newTableName));
        sb.append(String.format("SELECT setval('%1$s_id_seq', max(id) ) FROM %2$s;", newTableName, tableToCloneName));
        sb.append(String.format("ALTER TABLE %1$s ALTER id SET NOT NULL;", newTableName));
        sb.append(String.format("ALTER TABLE %1$s ALTER id SET DEFAULT nextval('%1$s_id_seq');", newTableName));
        return sb.toString();
    }

    @Override
    public void addColumn(String tableName, String columnName, DataType type) {
        String query = this.generateAddColumnQuery(tableName, columnName, type);
        this.executeQuery(query);
    }

    private String generateAddColumnQuery(String tableName, String columnName, DataType type) {
        return String.format("ALTER TABLE %1$s ADD COLUMN %2$s %3$s ", tableName, columnName, this.getColumnSQLType(type));
    }

    private String getColumnSQLType(DataType type) {
        return this.sqlModelMapper.translateDataTypeToSQL(type);
    }

    @Override
    public void removeColumn(String tableName, String columnName) {
        String query = this.generateDropColumnQuery(tableName, columnName);
        this.executeQuery(query);
    }

    private String generateDropColumnQuery(String tableName, String columnName) {
        return String.format("ALTER TABLE %1$s DROP COLUMN %2$s;", tableName, columnName);
    }

    private String generateTableName() {
        String tableName = null;
        int count = 0;
        do {
            tableName = RandomStringUtils.random((int)32, (boolean)true, (boolean)false).toLowerCase();
            log.debug("Generated table name: " + tableName);
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.adminConnectionProvider.getConnection();
                statement = connection.createStatement();
                statement.execute(String.format("SELECT * FROM pg_tables WHERE schemaname='%1$s' AND tablename='%2$s';", "public", tableName));
                count = statement.getFetchSize();
                log.debug(String.format("Table with name '%1$s' found %2$s times.", tableName, count));
            }
            catch (SQLException e) {
                try {
                    log.error("Error occurred while verifying generated table name.", (Throwable)e);
                    throw new RuntimeException("Unable to generate a table name", e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly((Connection)connection);
                    DbUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Connection)connection);
            DbUtils.closeQuietly((Statement)statement);
        } while (count > 0);
        return tableName;
    }

    private void executeQuery(String query) {
        log.debug("Executing SQL query: " + query);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.adminConnectionProvider.getConnection();
            statement = connection.createStatement();
            statement.execute(query + ";");
            connection.close();
        }
        catch (Exception e) {
            try {
                log.error("Unable to execute query: " + query, (Throwable)e);
                throw new RuntimeException("Error encountered while executing database query: " + query);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection);
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Connection)connection);
        DbUtils.closeQuietly((Statement)statement);
    }

    private String generateUserAccountGrantQuery(String tableName) {
        String unprivilegedUser = this.unprivilegedConnectionProvider.getDatabaseEndpoint().getCredentials().getUsername();
        return String.format("GRANT SELECT,UPDATE,INSERT ON TABLE %1$s TO %2$s;", tableName, unprivilegedUser);
    }

    @Override
    public void createIndex(String tableName, String columnName) {
        Thread t = new Thread(new IndexCreator(tableName, columnName));
        t.start();
    }

    private class IndexCreator
    implements Runnable {
        private String tableName;
        private String columnName;

        public IndexCreator(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }

        @Override
        public void run() {
            String query = String.format("CREATE INDEX ON %1$s ( %2$s );", this.tableName, this.columnName);
            SQLDatabaseWrangler.this.executeQuery(query);
        }
    }
}

