CREATE OR REPLACE FUNCTION update_gregorian_year_dimension() RETURNS trigger as $$
	DECLARE
		tmp_date date;
	BEGIN
		IF is_valid_year(NEW.year_code) THEN
			NEW.year_code := normalize_year(NEW.year_code);
			tmp_date := NEW.year_code || '-01-01';
			NEW.year := EXTRACT(YEAR FROM tmp_date);
			NEW.decade := EXTRACT(DECADE FROM tmp_date);
			RETURN NEW;
		ELSE
			RAISE EXCEPTION '%s is not a valid ISO8601 year code', quote_literal(year_code);
		END IF;
		
	END
$$ LANGUAGE plpgsql;