CREATE OR REPLACE FUNCTION update_gregorian_month_dimension() RETURNS trigger as $$
	DECLARE
		tmp_day date;
	BEGIN
		IF (is_valid_month(NEW.month_code)) THEN
			NEW.month_code := normalize_month(NEW.month_code);
			tmp_day := DATE(NEW.month_code || '-01');
			NEW.month_of_year := EXTRACT(MONTH FROM tmp_day);
			NEW.quarter_of_year := EXTRACT(QUARTER FROM tmp_day);
			NEW.year := EXTRACT(YEAR FROM tmp_day);
			NEW.decade := EXTRACT(DECADE FROM tmp_day);
			RETURN NEW;
		ELSE
			RAISE EXCEPTION '% is not a valid ISO8601 month code', quote_literal(month_code);
		END IF;
		
	END
$$ LANGUAGE plpgsql;