CREATE OR REPLACE FUNCTION update_gregorian_quarter_dimension() RETURNS trigger as $$
	DECLARE
		tmp_date date;
	BEGIN
		IF is_valid_quarter(NEW.quarter_code) THEN
			NEW.quarter_code := normalize_quarter(NEW.quarter_code);
			NEW.quarter_of_year := SUBSTRING(SUBSTRING(NEW.quarter_code FROM 'Q[0-9]') FROM '[1-4]$');
			RAISE NOTICE 'Evaluated Quearter of year: %',NEW.quarter_of_year;
			NEW.year := SUBSTRING(NEW.quarter_code FROM 'Q([1-4])$') AS integer;
			RAISE NOTICE 'Evaluated year: %',NEW.year;
			tmp_date := NEW.year || '-01-01';
			NEW.decade := EXTRACT(DECADE FROM tmp_date);
			RETURN NEW;
		ELSE
			RAISE EXCEPTION '% is not a valid quarter code', quote_literal(NEW.quarter_code);
		END IF;
		
	END
$$ LANGUAGE plpgsql;