CREATE OR REPLACE FUNCTION update_gregorian_day_dimension() RETURNS trigger as $$
	DECLARE
		tmp_day date;
	BEGIN
		IF is_valid_date(NEW.day_code) THEN
			NEW.day_code := normalize_day(NEW.day_code);
			tmp_day := DATE(NEW.day_code);
			NEW.the_day = tmp_day;
			NEW.week_of_iso_year := EXTRACT(WEEK FROM tmp_day);
			NEW.month_of_year := EXTRACT(MONTH FROM tmp_day);
			NEW.quarter_of_year := EXTRACT(QUARTER FROM tmp_day);
			NEW.year := EXTRACT(YEAR FROM tmp_day);
			NEW.iso_year := EXTRACT(ISOYEAR FROM tmp_day);
			NEW.decade := EXTRACT(DECADE FROM tmp_day);
			RETURN NEW;
		ELSE
			RAISE EXCEPTION '% is not a valid ISO8601 day code', quote_literal(tmp_day);
		END IF;
		
	END
$$ LANGUAGE plpgsql;