/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.enterprise.inject.Default;
import org.gcube.data.analysis.tabulardata.cube.data.ResourceFinder;

@Default
public class ResourceList
implements ResourceFinder {
    @Override
    public InputStream getStream(String file) {
        return ClassLoader.getSystemResourceAsStream(file);
    }

    @Override
    public Collection<String> getResourcesPath(Pattern pattern) {
        String[] classPathElements;
        ArrayList<String> retval = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path");
        for (String element : classPathElements = classPath.split(":")) {
            retval.addAll(this.getResources(element, pattern));
        }
        return retval;
    }

    protected Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(element);
        if (file.isDirectory()) {
            retval.addAll(this.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(this.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    protected Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retval;
    }

    protected Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(this.getResourcesFromDirectory(file, pattern));
                continue;
            }
            String fileName = file.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        return retval;
    }
}

