package org.gcube.data.analysis.tabulardata.cube.metadata;

import java.util.List;

import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATable;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.TableFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Lists;

@Default @Singleton
public class JPAMetadataWrangler implements CubeMetadataWrangler {

	Logger log = LoggerFactory.getLogger(JPAMetadataWrangler.class);
	
	EntityManager em;

	@Inject
	public JPAMetadataWrangler(EntityManager em) {
		super();
		this.em = em;
	}
	
	public Table update(Table table){
		JPATable jpaTable = new JPATable(table);
		mergeEntity(jpaTable);
		return TableFactory.createModelTable(jpaTable);
	}

	@Override
	public Table save(Table table) {
		JPATable jpaTable = new JPATable(table);
		persistEntity(jpaTable);
		return TableFactory.createModelTable(jpaTable);
	}

	@Override
	public Table get(long id) throws NoSuchTableException {
		TypedQuery<JPATable> query = getEntityManager().createNamedQuery("Table.findById", JPATable.class);
		query.setParameter("Id", id);
		List<JPATable> queryResult = query.getResultList();
		if (queryResult.size() > 0)
			return TableFactory.createModelTable(queryResult.get(0));
		throw new NoSuchTableException(id);
	}

	@Override
	public List<Table> getAll() {
		List<Table> tables = Lists.newArrayList();
		TypedQuery<JPATable> query = getEntityManager().createNamedQuery("Table.findAll", JPATable.class);
		for (JPATable jpaTable : query.getResultList()) {
			tables.add(TableFactory.createModelTable(jpaTable));
		}
		return tables;
	}

	@Override
	public List<Table> getAll(TableType tableType) {
		TypedQuery<JPATable> query = getEntityManager().createNamedQuery("Table.findAllByType", JPATable.class);
		query.setParameter("TableType", tableType);
		List<Table> tables = Lists.newArrayList();
		for (JPATable jpaTable : query.getResultList()) {
			tables.add(TableFactory.createModelTable(jpaTable));
		}
		return tables;
	}

	@Override
	public void remove(long id) throws NoSuchTableException {
		removeEntity(get(id));
	}

	private void persistEntity(Object entity) {
		getEntityManager().getTransaction().begin();
		getEntityManager().persist(entity);
		getEntityManager().getTransaction().commit();
		log.debug("Saved entity: " + entity);
	}
	
	private void mergeEntity(Object entity){
		log.debug("Updating entity: " + entity);
		getEntityManager().getTransaction().begin();
		getEntityManager().merge(entity);
		getEntityManager().getTransaction().commit();
		log.debug("Updated entity: " + entity);
	}

	private void removeEntity(Object entity) {
		getEntityManager().getTransaction().begin();
		getEntityManager().remove(entity);
		getEntityManager().getTransaction().commit();
	}

	private EntityManager getEntityManager() {
		return em;
	}

}
