package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.gcube.data.analysis.tabulardata.model.metadata.CubeMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

import com.google.common.collect.Lists;

@Entity(name = "TDTable")
@NamedQueries({ @NamedQuery(name = "Table.findAll", query = "SELECT t FROM TDTable AS t"),
		@NamedQuery(name = "Table.findAllByType", query = "SELECT t FROM TDTable AS t WHERE t.tableType = :TableType"),
		@NamedQuery(name = "Table.findById", query = "SELECT t FROM TDTable AS t WHERE t.id = :Id") })
@SequenceGenerator(name = "tdtable_seq", sequenceName = "tdtable_seq", allocationSize = 1)
public class JPATable {

	@Id
	@Column(name = "ID", nullable = false)
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "tdtable_seq")
	private long id;

	private String name;

	private TableType tableType;

	private boolean exists;

	private Long parentTableId = null;

	@OneToMany(cascade = CascadeType.ALL)
	private Collection<JPAColumn> columns = Lists.newArrayList();

	private ArrayList<CubeMetadata<Serializable>> metadata = Lists.newArrayList();

	@Column(insertable = true, updatable = false)
	@Temporal(TemporalType.TIMESTAMP)
	public Date createdTimestamp = new Date();

	@Column(insertable = true, updatable = false)
	@Temporal(TemporalType.TIMESTAMP)
	public Date updatedTimestamp = new Date();

	@SuppressWarnings("unused")
	private JPATable() {
	}

	public JPATable(Table table) {
		super();
		if (table.getId() != null)
			this.id = table.getId();
		this.name = table.getName();
		this.tableType = table.getTableType();
		for (org.gcube.data.analysis.tabulardata.model.column.Column column : table.getColumns()) {
			columns.add(new JPAColumn(column));
		}
		this.metadata.addAll(table.getAllMetadata());
		this.exists = table.exists();
		this.parentTableId = table.getParentTableId();
	}

	public long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public TableType getTableType() {
		return tableType;
	}

	public Collection<JPAColumn> getColumns() {
		return columns;
	}

	public Collection<CubeMetadata<Serializable>> getMetadata() {
		return metadata;
	}

	public void setMetadata(Collection<CubeMetadata<Serializable>> metadata) {
		this.metadata = Lists.newArrayList(metadata);
	}

	public Date getCreatedTimestamp() {
		return createdTimestamp;
	}

	public Date getUpdatedTimestamp() {
		return updatedTimestamp;
	}

	public boolean exists() {
		return exists;
	}

	public void setExists(boolean exists) {
		this.exists = exists;
	}

	public Long getParentTableId() {
		return parentTableId;
	}

	public void setParentTableId(Long parentTableId) {
		this.parentTableId = parentTableId;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("JPATable [id=");
		builder.append(id);
		builder.append(", name=");
		builder.append(name);
		builder.append(", tableType=");
		builder.append(tableType);
		builder.append(", exists=");
		builder.append(exists);
		builder.append(", parentTableId=");
		builder.append(parentTableId);
		builder.append(", columns=");
		builder.append(columns);
		builder.append(", metadata=");
		builder.append(metadata);
		builder.append(", createdTimestamp=");
		builder.append(createdTimestamp);
		builder.append(", updatedTimestamp=");
		builder.append(updatedTimestamp);
		builder.append("]");
		return builder.toString();
	}
	
	

}
