package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

import com.google.common.collect.Lists;

@Entity(name = "TDColumn")
@SequenceGenerator(name = "tdcolumn_seq", sequenceName = "tdcolumn_seq", allocationSize = 1)
public class JPAColumn {

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "tdcolumn_seq")
	private long id;
	
	private UUID localId;

	private String name;

	private String label;

	private ColumnType type;

	private DataType dataType;

	private ColumnRelationship relationship = null;
	
	private ArrayList<ColumnMetadata> metadata = Lists.newArrayList();

	@Column(insertable = true, updatable = false)
	@Temporal(TemporalType.TIMESTAMP)
	public Date createdTimestamp = new Date();

	@Column(insertable = true, updatable = false)
	@Temporal(TemporalType.TIMESTAMP)
	public Date updatedTimestamp = new Date();
	
	public JPAColumn() {
	}
	
	public long getColumnId() {
		return id;
	}

	public UUID getLocalId() {
		return localId;
	}

	public void setLocalId(UUID localId) {
		this.localId = localId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public ColumnType getType() {
		return type;
	}

	public void setType(ColumnType type) {
		this.type = type;
	}

	public DataType getDataType() {
		return dataType;
	}

	public void setDataType(DataType dataType) {
		this.dataType = dataType;
	}

	public ColumnRelationship getRelationship() {
		return relationship;
	}

	public void setRelationship(ColumnRelationship relationship) {
		this.relationship = relationship;
	}

	public Collection<ColumnMetadata> getMetadata() {
		return metadata;
	}

	public void setMetadata(Collection<ColumnMetadata> metadata) {
		this.metadata = Lists.newArrayList(metadata);
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("JPAColumn [id=");
		builder.append(id);
		builder.append(", name=");
		builder.append(name);
		builder.append(", label=");
		builder.append(label);
		builder.append(", type=");
		builder.append(type);
		builder.append(", dataType=");
		builder.append(dataType);
		builder.append(", relationship=");
		builder.append(relationship);
		builder.append(", metadata=");
		builder.append(metadata);
		builder.append(", createdTimestamp=");
		builder.append(createdTimestamp);
		builder.append(", updatedTimestamp=");
		builder.append(updatedTimestamp);
		builder.append("]");
		return builder.toString();
	}

}
