/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.gcube.common.database.DatabaseEndpointIdentifier;
import org.gcube.common.database.DatabaseProvider;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.database.endpoint.DatabaseProperty;

@Singleton
public class ISEntityManagerProvider {
    private DatabaseEndpointIdentifier metaDBEndpointId;
    private DatabaseProvider dbProvider;
    private EntityManager em;

    public ISEntityManagerProvider(DatabaseEndpointIdentifier metaDBEndpointId, DatabaseProvider dbProvider) {
        this.metaDBEndpointId = metaDBEndpointId;
        this.dbProvider = dbProvider;
    }

    public EntityManager get() {
        if (this.em == null) {
            DatabaseEndpoint dbDescriptor = this.dbProvider.get(this.metaDBEndpointId);
            String driver = null;
            String eclipseLinkTargetDb = null;
            String ddlGenerationStrategy = null;
            for (DatabaseProperty p : dbDescriptor.getProperties()) {
                if (p.getKey().equals("driver")) {
                    driver = p.getValue();
                }
                if (p.getKey().equals("eclipselink.target-database")) {
                    eclipseLinkTargetDb = p.getValue();
                }
                if (!p.getKey().equals("eclipselink.ddl-generation")) continue;
                ddlGenerationStrategy = p.getValue();
            }
            if (driver == null) {
                throw new RuntimeException("Unable to find the right driver for the connection to the DB: " + dbDescriptor);
            }
            HashMap properties = Maps.newHashMap();
            properties.put("javax.persistence.jdbc.user", dbDescriptor.getCredentials().getUsername());
            properties.put("javax.persistence.jdbc.password", dbDescriptor.getCredentials().getPassword());
            properties.put("javax.persistence.jdbc.driver", driver);
            properties.put("javax.persistence.jdbc.url", dbDescriptor.getConnectionString());
            properties.put("eclipselink.target-database", eclipseLinkTargetDb);
            if (ddlGenerationStrategy != null) {
                properties.put("eclipselink.ddl-generation", ddlGenerationStrategy);
            } else {
                properties.put("eclipselink.ddl-generation", "create-tables");
            }
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"default", (Map)properties);
            this.em = emf.createEntityManager();
        }
        return this.em;
    }

    public void close() {
        this.em.flush();
        this.em.close();
        this.em = null;
    }

    public boolean isInitialized() {
        return this.em != null;
    }
}

