/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

@Entity(name="TDColumn")
@SequenceGenerator(name="tdcolumn_seq", sequenceName="tdcolumn_seq", allocationSize=1)
public class JPAColumn {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="tdcolumn_seq")
    private long id;
    private String localId;
    private String name;
    private ColumnType type;
    private DataType dataType;
    private int position;
    private ColumnRelationship relationship = null;
    private ArrayList<ColumnMetadata> metadata = Lists.newArrayList();
    @Column(insertable=true, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date createdTimestamp = new Date();
    @Column(insertable=true, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date updatedTimestamp = new Date();

    public void setColumnId(long id) {
        this.id = id;
    }

    public long getColumnId() {
        return this.id;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public void setType(ColumnType type) {
        this.type = type;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public ColumnRelationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ColumnRelationship relationship) {
        this.relationship = relationship;
    }

    public Collection<ColumnMetadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Collection<ColumnMetadata> metadata) {
        this.metadata = Lists.newArrayList(metadata);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JPAColumn [\n\tid=");
        builder.append(this.id);
        builder.append(",\n\tposition=");
        builder.append(this.position);
        builder.append(",\n\tlocalId=");
        builder.append(this.localId);
        builder.append(",\n\tname=");
        builder.append(this.name);
        builder.append(",\n\ttype=");
        builder.append(this.type);
        builder.append(",\n\tdataType=");
        builder.append(this.dataType);
        builder.append(",\n\trelationship=");
        builder.append(this.relationship);
        builder.append(",\n\tmetadata=");
        builder.append(this.metadata);
        builder.append(",\n\tcreatedTimestamp=");
        builder.append(this.createdTimestamp);
        builder.append(",\n\tupdatedTimestamp=");
        builder.append(this.updatedTimestamp);
        builder.append("\n]");
        return builder.toString();
    }
}

