package org.gcube.data.analysis.tabulardata.cube.tablemanagers.generic;

import java.util.Collection;

import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.StatefulTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.GenericTable;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public class GenericTableCreator extends StatefulTableCreator {

	public GenericTableCreator(DatabaseWrangler dw, CubeMetadataWrangler cmw, TableManager tm) {
		super(dw, cmw, tm);
	}

	@Override
	protected Table createBaseTable(String tableName, Collection<Column> columns) {
		return new GenericTable(tableName, columns);
	}

	@Override
	protected void checkConsistency() throws TableCreationException {
		// Verify label uniqueness
		checkDuplicateLabels(getAllColumns());

		// Check that at least one column is provided
		if (getAllColumns().size() == 0)
			throw new TableCreationException("No column was provided.");
	}

	@Override
	protected boolean isAllowedColumn(Column column) {
		switch (column.getColumnType()) {
		case ATTRIBUTE:
			return true;
		default:
			return false;
		}
	}

	@Override
	protected boolean isAllowedCloneableTable(Table table) {
		return true;
	}

	@Override
	protected void addIndexes(String tableName, Collection<Column> columns) {
		//Do nothing
	}

}
