package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import java.util.Collection;

import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public interface TableCreator {
	
	public TableCreator addColumn(Column column);

	public TableCreator addColumns(Column... columns);

	public TableCreator like(Table table, boolean withData);

	public TableCreator like(Table table, boolean withData, Collection<Column> columnsToRemove);
	
	//TODO Remove column method

	public Table create() throws TableCreationException;

}
