/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.ViewTable;

public class ViewTableCreator
extends DefaultTableCreator {
    private List<Column> newColumns = Lists.newArrayList();
    private Table tableToClone;
    private List<Column> columnsToRemove = Lists.newArrayList();
    private boolean withData;

    public ViewTableCreator(DatabaseWrangler dw, CubeMetadataWrangler cmw, TableManager tm) {
        super(dw, cmw, tm);
    }

    @Override
    protected Collection<Column> getAllColumns() {
        ArrayList columns = Lists.newArrayList();
        if (this.tableToClone != null) {
            columns.addAll(this.tableToClone.getColumns());
            columns.removeAll(this.columnsToRemove);
        }
        while (columns.remove(new IdColumn())) {
        }
        columns.addAll(this.newColumns);
        return columns;
    }

    @Override
    protected Collection<Column> getNewColumns() {
        return this.newColumns;
    }

    @Override
    protected Table createBaseTable(String tableName, Collection<Column> columns) {
        return new ViewTable(tableName, this.getAllColumns());
    }

    @Override
    protected void checkConsistency() throws TableCreationException {
        try {
            this.checkDuplicateLabels(this.getAllColumns());
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
        try {
            this.checkColumnsRelationship(this.getAllColumns());
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
    }

    @Override
    protected boolean isAllowedColumn(Column column) {
        switch (column.getColumnType()) {
            case ATTRIBUTE: 
            case MEASURE: 
            case SYSTEM: 
            case CODELISTREF: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addNewColumn(Column column) {
        this.newColumns.add(column);
    }

    @Override
    protected boolean isAllowedCloneableTable(Table table) {
        switch (table.getTableType()) {
            case DATASET: 
            case VIEWTABLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Table getTableToClone() {
        return this.tableToClone;
    }

    @Override
    protected void setTableToClone(Table table) {
        this.tableToClone = table;
    }

    @Override
    protected boolean isCloneWithData() {
        return this.withData;
    }

    @Override
    protected void setCloneWithData(boolean cloneWithData) {
        this.withData = cloneWithData;
    }

    @Override
    protected Collection<Column> getColumnsToRemove() {
        return this.columnsToRemove;
    }

    @Override
    protected void setColumnsToRemove(Collection<Column> columns) {
        this.columnsToRemove = Lists.newArrayList(columns);
    }

    @Override
    protected void addIndexes(String tableName, Collection<Column> columns) {
        for (Column column : columns) {
            switch (column.getColumnType()) {
                case CODELISTREF: 
                case ID: {
                    this.dbWrangler.createIndex(tableName, column.getName());
                }
            }
        }
    }

    @Override
    public Table create() throws TableCreationException {
        this.checkConsistency();
        this.setColumnNames(this.getAllColumns());
        String tableName = null;
        if (this.getTableToClone() != null) {
            tableName = this.dbWrangler.cloneTable(this.getTableToClone().getName(), this.isCloneWithData(), true);
            for (Column column : this.getColumnsToRemove()) {
                this.dbWrangler.removeColumn(tableName, column.getName());
            }
            for (Column column : this.getNewColumns()) {
                this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            }
        } else {
            tableName = this.dbWrangler.createTable(true);
            for (Column column : this.getNewColumns()) {
                this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            }
        }
        this.addIndexes(tableName, this.getAllColumns());
        Collection<Column> columns = this.getAllColumns();
        columns.add((Column)new IdColumn());
        Table newTable = this.createBaseTable(tableName, columns);
        if (this.getTableToClone() != null) {
            newTable.setParentTableId(this.getTableToClone().getId());
            this.cloneMetadata(this.getTableToClone(), newTable);
        }
        return this.mdWrangler.save(newTable);
    }
}

