/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import java.util.Collection;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

@Default
public class TableManagerImpl
implements TableManager {
    private DatabaseWrangler dbWrangler;
    private CubeMetadataWrangler cmWrangler;

    @Inject
    public TableManagerImpl(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler) {
        this.dbWrangler = dbWrangler;
        this.cmWrangler = cmWrangler;
    }

    @Override
    public Collection<Table> getAll() {
        return this.cmWrangler.getAll();
    }

    @Override
    public Collection<Table> getAll(TableType tableType) {
        return this.cmWrangler.getAll(tableType);
    }

    @Override
    public Table get(TableId id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        try {
            return this.cmWrangler.get(id);
        }
        catch (NoSuchTableException e) {
            throw new org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException(id);
        }
    }

    @Override
    public void remove(TableId id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        Table tableToRemove = this.get(id);
        Collection<Table> tables = this.getAll();
        boolean dbTableUsedElsewhere = false;
        for (Table presentTable : tables) {
            if (presentTable.equals((Object)tableToRemove) || !tableToRemove.getName().equals(presentTable.getName())) continue;
            dbTableUsedElsewhere = true;
            break;
        }
        if (!dbTableUsedElsewhere) {
            this.dbWrangler.removeTable(tableToRemove.getName());
        }
        this.removeTableMetadata(tableToRemove.getId());
    }

    private void removeTableMetadata(TableId id) throws org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException {
        try {
            this.cmWrangler.remove(id);
        }
        catch (NoSuchTableException e) {
            throw new org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException(id);
        }
    }
}

