/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

@Default
public class TableManagerImpl
implements TableManager {
    private DatabaseWrangler dbWrangler;
    private CubeMetadataWrangler cmWrangler;

    @Inject
    public TableManagerImpl(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler) {
        this.dbWrangler = dbWrangler;
        this.cmWrangler = cmWrangler;
    }

    @Override
    public Collection<Table> getAll() {
        return this.cmWrangler.getAll();
    }

    @Override
    public Collection<Table> getAll(TableType tableType) {
        return this.cmWrangler.getAll(tableType);
    }

    @Override
    public Table get(TableId id) throws NoSuchTableException {
        try {
            return this.cmWrangler.get(id);
        }
        catch (org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(id);
        }
    }

    @Override
    public void remove(TableId id) throws NoSuchTableException {
        Table tableToRemove = this.get(id);
        Collection<Table> tables = this.getAll();
        boolean dbTableUsedElsewhere = false;
        for (Table presentTable : tables) {
            if (presentTable.equals((Object)tableToRemove) || !tableToRemove.getName().equals(presentTable.getName())) continue;
            dbTableUsedElsewhere = true;
            break;
        }
        if (!dbTableUsedElsewhere) {
            this.dbWrangler.removeTable(tableToRemove.getName());
        }
        this.removeTableMetadata(tableToRemove.getId());
    }

    private void removeTableMetadata(TableId id) throws NoSuchTableException {
        try {
            this.cmWrangler.remove(id);
        }
        catch (org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(id);
        }
    }

    @Override
    public Table removeValidationColumns(TableId id) throws NoSuchTableException {
        Table table;
        try {
            table = this.cmWrangler.get(id);
        }
        catch (org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(id);
        }
        ArrayList<Column> remainedColumns = new ArrayList<Column>();
        for (Column col : table.getColumns()) {
            if (col.getColumnType() instanceof ValidationColumnType) {
                this.dbWrangler.removeColumn(table.getName(), col.getName());
                continue;
            }
            remainedColumns.add(col);
        }
        table.setColumns(remainedColumns);
        return table;
    }

    @Override
    public Table addValidationColumns(TableId id, Column ... validationColumns) throws NoSuchTableException {
        Table table;
        try {
            table = this.cmWrangler.get(id);
        }
        catch (org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(id);
        }
        List oldColumns = table.getColumns();
        for (Column col : validationColumns) {
            String eligibleName;
            if (!(col.getColumnType() instanceof ValidationColumnType)) continue;
            while (!Collections2.filter((Collection)oldColumns, (Predicate)new ColumnHasName(eligibleName = DefaultTableCreator.ColumnNameGenerator.generateColumnName())).isEmpty()) {
            }
            col.setName(eligibleName);
            this.dbWrangler.addColumn(table.getName(), col.getName(), col.getDataType(), col.getCreationDefaultValue());
            oldColumns.add(col);
        }
        return table;
    }

    @Override
    public void save(Table table, boolean overwrite) {
        this.cmWrangler.save(table, overwrite);
    }

    @Override
    public Table removeColumn(TableId id, ColumnLocalId localId) throws NoSuchTableException {
        Column column;
        Table table;
        try {
            table = this.cmWrangler.get(id);
            column = table.getColumnById(localId);
        }
        catch (Exception e) {
            throw new NoSuchTableException(id);
        }
        List columns = table.getColumns();
        columns.remove(column);
        this.dbWrangler.removeColumn(table.getName(), column.getName());
        table.setColumns(columns);
        return table;
    }
}

