package org.gcube.data.analysis.tabulardata.operation.factories.types;

import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor.OperationId;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor.OperationType;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public abstract class BaseWorkerFactory implements WorkerFactory {

	protected abstract String getOperationName();

	protected abstract String getOperationDescription();

	protected OperationId getOperationId() {
		return new OperationId(this.getClass());
	}

	protected abstract OperationScope getOperationScope();

	protected abstract OperationType getOperationType();

	@Override
	public OperationDescriptor getOperationDescriptor() {
		return new OperationDescriptor(getOperationId(), getOperationName(), getOperationDescription(),
				getOperationScope(), getOperationType());
	}

	@SuppressWarnings({ "unused", "unchecked" })
	protected <T> void checkParameterValue(String id, Class<T> type, OperationInvocation invocation)
			throws InvalidInvocationException {
		Object obj = invocation.getParameterInstances().get(id);
		if (obj == null)
			throw new InvalidInvocationException(invocation, String.format(
					"Parameter %s is missing", id));
		T typedParameter = null;
		try {
			typedParameter = (T) obj;
		} catch (Exception e) {
			throw new InvalidInvocationException(invocation, e.getMessage());
		}
	}

	@SuppressWarnings("unchecked")
	protected <T> T getParameterValue(String id, Class<T> type, OperationInvocation invocation)
			throws InvalidInvocationException {
		checkParameterValue(id, type, invocation);
		return (T) invocation.getParameterInstances().get(id);
	}

	protected void checkTableIdPresence(OperationInvocation invocation) throws InvalidInvocationException{
		if (invocation.getTargetTableId() == null ) throw new InvalidInvocationException(invocation, "Target table is missing");
	}

	protected void checkColumnIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
		if (invocation.getTargetColumnId() == null ) throw new InvalidInvocationException(invocation, "Target column is missing");
	}

}
