package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;

import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class MultivaluedStringParameter extends LeafParameter<String> {

	private List<String> admittedValues = null;
	
	@SuppressWarnings("unused")
	private MultivaluedStringParameter() {}

	public MultivaluedStringParameter(String identifier, String name, String description, Cardinality cardinality,
			List<String> admittedValues) {
		super(identifier, name, description, cardinality);
		if (admittedValues==null || admittedValues.isEmpty()) throw new IllegalArgumentException("Must provide a non empty list of admitted values");
		this.admittedValues = admittedValues;
	}
	
	public boolean validate(String value){
		return getAdmittedValues().contains(value);
	}

	public List<String> getAdmittedValues() {
		return admittedValues;
	}

	@Override
	public Class<String> getParameterType() {
		return String.class;
	}
	
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((admittedValues == null) ? 0 : admittedValues.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		MultivaluedStringParameter other = (MultivaluedStringParameter) obj;
		if (admittedValues == null) {
			if (other.admittedValues != null)
				return false;
		} else if (!admittedValues.equals(other.admittedValues))
			return false;
		return true;
	}

	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("MultivaluedStringParameter [getIdentifier()=");
		builder.append(getIdentifier());
		builder.append(", getName()=");
		builder.append(getName());
		builder.append(", getDescription()=");
		builder.append(getDescription());
		builder.append(", getCardinality()=");
		builder.append(getCardinality());
		builder.append(", getAdmittedValues()=");
		builder.append(getAdmittedValues());
		builder.append(", getParameterType()=");
		builder.append(getParameterType());
		builder.append("]");
		return builder.toString();
	}

	
}
