/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class MultivaluedStringParameter
extends LeafParameter<String> {
    private List<String> admittedValues = null;

    private MultivaluedStringParameter() {
    }

    public MultivaluedStringParameter(String identifier, String name, String description, Cardinality cardinality, List<String> admittedValues) {
        super(identifier, name, description, cardinality);
        if (admittedValues == null || admittedValues.isEmpty()) {
            throw new IllegalArgumentException("Must provide a non empty list of admitted values");
        }
        this.admittedValues = admittedValues;
    }

    public boolean validate(String value) {
        return this.getAdmittedValues().contains(value);
    }

    public List<String> getAdmittedValues() {
        return this.admittedValues;
    }

    @Override
    public Class<String> getParameterType() {
        return String.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.admittedValues == null ? 0 : this.admittedValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultivaluedStringParameter other = (MultivaluedStringParameter)obj;
        return !(this.admittedValues == null ? other.admittedValues != null : !this.admittedValues.equals(other.admittedValues));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultivaluedStringParameter [getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append(", getAdmittedValues()=");
        builder.append(this.getAdmittedValues());
        builder.append(", getParameterType()=");
        builder.append(this.getParameterType());
        builder.append("]");
        return builder.toString();
    }
}

