/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.Observable;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Worker
extends Observable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    private float progress = 0.0f;
    private WorkerException exception = null;
    private WorkerResult result = null;
    private WorkerStatus status = WorkerStatus.INITIALIZING;
    private OperationInvocation sourceInvocation;

    public Worker(OperationInvocation sourceInvocation) {
        this.sourceInvocation = sourceInvocation;
    }

    protected void updateProgress(float progress) {
        if (progress <= 0.0f || progress >= 1.0f) {
            throw new IllegalArgumentException("When updating progress, progress value must be between 0 and 1 (excluded)");
        }
        this.progress = progress;
        this.status = WorkerStatus.IN_PROGRESS;
        this.setChanged();
        this.notifyObservers(this);
    }

    protected abstract WorkerResult execute() throws WorkerException;

    @Override
    public void run() {
        try {
            log.debug("Starting worker: " + this.getClass().getSimpleName());
            WorkerResult result = this.execute();
            this.succeded(result);
            log.debug("Worker ended execution succesfully: " + this.getClass().getSimpleName());
        }
        catch (WorkerException e) {
            log.debug("Worker failed execution: " + this.getClass().getSimpleName());
            this.failed(e);
        }
        catch (Exception e) {
            log.debug("Worker failed execution: " + this.getClass().getSimpleName());
            this.failed(new WorkerException("Internal operation error", e));
        }
    }

    private void succeded(WorkerResult result) {
        this.progress = 1.0f;
        this.result = result;
        this.status = WorkerStatus.SUCCEDED;
        this.setChanged();
        this.notifyObservers(this);
    }

    private void failed(WorkerException e) {
        this.status = e.getFallbackWorker() != null ? WorkerStatus.FALLBACK : WorkerStatus.FAILED;
        this.exception = e;
        this.setChanged();
        this.notifyObservers(this);
    }

    public float getProgress() {
        return this.progress;
    }

    public WorkerException getException() {
        return this.exception;
    }

    public WorkerResult getResult() {
        return this.result;
    }

    public WorkerStatus getStatus() {
        return this.status;
    }

    public OperationInvocation getSourceInvocation() {
        return this.sourceInvocation;
    }
}

