package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerWrapper {

private static final Logger log = LoggerFactory.getLogger(WorkerWrapper.class);
	
	private WorkerFactory factory;
	private Worker lastWorker;
	
	
	public WorkerWrapper(WorkerFactory wrapped) {		
		this.factory = wrapped;
	}


	public WorkerStatus execute(TableId tableId, ColumnLocalId columnId, Map<String,Object> parameters) throws InvalidInvocationException{
		OperationDescriptor descriptor=factory.getOperationDescriptor();
		if(parameters==null)parameters=new HashMap<String,Object>();
		InvocationCreator creator=InvocationCreator.getCreator(descriptor).setParameters(parameters);
		if(!descriptor.getScope().equals(OperationScope.VOID))creator.setTargetTable(tableId);
		if(descriptor.getScope().equals(OperationScope.COLUMN)) creator.setTargetColumn(columnId);
		OperationInvocation invocation=creator.create();	
		
		lastWorker=factory.createWorker(invocation);
		log.debug("Running sub - worker : "+lastWorker+", with "+invocation);
		lastWorker.run();
		return lastWorker.getStatus();
	}
	
	
	public WorkerResult getResult(){
		return lastWorker.getResult();
	}
}
