/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class OperationHelper {
    public static <T> T getParameter(LeafParameter<T> parameter, OperationInvocation invocation) {
        Object instance = invocation.getParameterInstances().get(parameter.getIdentifier());
        if (instance == null) {
            throw new RuntimeException(String.format("Parameter with id '%s' not found in invocation", parameter.getIdentifier()));
        }
        try {
            return (T)instance;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(String.format("Provided parameter with id '%s' is not of valid type", parameter.getIdentifier()));
        }
    }

    public static final String retrieveColumnLabel(Column targetColumn) {
        if (targetColumn.contains(NamesMetadata.class)) {
            NamesMetadata namesMeta = (NamesMetadata)targetColumn.getMetadata(NamesMetadata.class);
            if (namesMeta.hasTextWithLocale(Locales.getDefaultLocale())) {
                return namesMeta.getTextWithLocale(Locales.getDefaultLocale()).getValue();
            }
            if (namesMeta.getTexts().size() > 0) {
                return ((LocalizedText)namesMeta.getTexts().get(0)).getValue();
            }
        }
        return targetColumn.getName();
    }

    public static final String retrieveTableLabel(Table targetTable) {
        if (targetTable.contains(NamesMetadata.class)) {
            NamesMetadata namesMeta = (NamesMetadata)targetTable.getMetadata(NamesMetadata.class);
            if (namesMeta.hasTextWithLocale(Locales.getDefaultLocale())) {
                return namesMeta.getTextWithLocale(Locales.getDefaultLocale()).getValue();
            }
            if (namesMeta.getTexts().size() > 0) {
                return ((LocalizedText)namesMeta.getTexts().get(0)).getValue();
            }
        } else if (targetTable.contains(TableDescriptorMetadata.class)) {
            TableDescriptorMetadata tdm = (TableDescriptorMetadata)targetTable.getMetadata(TableDescriptorMetadata.class);
            return String.format("%s[%s]", tdm.getName(), tdm.getVersion());
        }
        return targetTable.getName();
    }

    public static final String getColumnNamesSnippet(Collection<Column> columns) {
        StringBuilder columnNamesSnippet = new StringBuilder();
        for (Column col : columns) {
            columnNamesSnippet.append(String.valueOf(col.getName()) + ", ");
        }
        columnNamesSnippet.delete(columnNamesSnippet.length() - 2, columnNamesSnippet.length() - 1);
        return columnNamesSnippet.toString();
    }

    public static final String getColumnLabelsSnippet(Collection<Column> columns) {
        StringBuilder columnNamesSnippet = new StringBuilder();
        for (Column col : columns) {
            columnNamesSnippet.append(String.valueOf(OperationHelper.retrieveColumnLabel(col)) + ", ");
        }
        columnNamesSnippet.delete(columnNamesSnippet.length() - 2, columnNamesSnippet.length() - 1);
        return columnNamesSnippet.toString();
    }

    public static InputStream getInputStreamFromUrl(String url) throws Exception {
        InputStream inputStream;
        try {
            inputStream = URI.create(url).toURL().openStream();
        }
        catch (MalformedURLException mue) {
            inputStream = new URL(null, url.toString(), new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    System.out.println("is smp url");
                    return new SMPURLConnection(url);
                }
            }).openStream();
        }
        return inputStream;
    }
}

