package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;

import java.util.Calendar;

public class ImmutableTableResource implements ResourceDescriptorResult{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3369581598451116331L;
	
	private TableResource table;
	private String description;
	private Calendar creationDate;
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	
	public ImmutableTableResource(TableResource table,
			String description, Calendar creationDate) {
		super();
		this.table = table;
		this.description = description;
		this.creationDate = creationDate;
	}
	
	public ImmutableTableResource(TableResource table, String description,
			Calendar creationDate, ResourceScope resourceScope) {
		super();
		this.table = table;
		this.description = description;
		this.creationDate = creationDate;
		this.resourceScope = resourceScope;
	}

	@Override
	public TableResource getResource() {
		return table;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}

	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}

}
