/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.factories.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.ImmutableOperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.ColumnScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.TableScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnMetadataParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextChoiceParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MapParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TDTypeValueParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetTableParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public abstract class BaseWorkerFactory<T extends Worker<?>>
implements WorkerFactory<T> {
    protected abstract String getOperationName();

    protected abstract String getOperationDescription();

    protected OperationId getOperationId() {
        return new OperationId(this.getClass());
    }

    @Override
    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isRollbackable() {
        return false;
    }

    @Override
    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        throw new UnsupportedOperationException();
    }

    protected abstract OperationScope getOperationScope();

    protected abstract OperationType getOperationType();

    @Override
    public OperationDescriptor getOperationDescriptor() {
        return new ImmutableOperationDescriptor(this.getOperationId(), this.getOperationName(), this.getOperationDescription(), this.getOperationScope(), this.getOperationType(), this.getParameters());
    }

    protected abstract List<Parameter> getParameters();

    private void checkParameters(List<Parameter> toCheckParams, Map<String, Object> paramInstances, OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        for (Parameter parameter : toCheckParams) {
            if (paramInstances.containsKey(parameter.getIdentifier()) && paramInstances.get(parameter.getIdentifier()) == null) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is null", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 0 && !paramInstances.containsKey(parameter.getIdentifier())) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 1 && !(paramInstances.get(parameter.getIdentifier()) instanceof Iterable)) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s must be multiple", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMaximum() == 1 && paramInstances.get(parameter.getIdentifier()) instanceof Iterable) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s cannot be multiple", parameter.getIdentifier()));
            }
            Object value = paramInstances.get(parameter.getIdentifier());
            if (value == null) continue;
            if (value instanceof Iterable) {
                int instanceCount = 0;
                for (Object obj : (Iterable)value) {
                    ++instanceCount;
                    this.checkParameterInstance(obj, parameter, invocation, cubeManager);
                    if (!(parameter instanceof CompositeParameter)) continue;
                    this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)obj, invocation, cubeManager);
                }
                if (instanceCount < parameter.getCardinality().getMinimum()) {
                    throw new InvalidInvocationException(invocation, String.format("Not enough %s parameter instances(found %s instances), minimum is %s ", parameter.getIdentifier(), instanceCount, parameter.getCardinality().getMinimum()));
                }
                if (instanceCount <= parameter.getCardinality().getMaximum()) continue;
                throw new InvalidInvocationException(invocation, String.format("Too many %s parameter instances(found %s instances), maximum is %s ", parameter.getIdentifier(), instanceCount, parameter.getCardinality().getMaximum()));
            }
            this.checkParameterInstance(value, parameter, invocation, cubeManager);
            if (!(parameter instanceof CompositeParameter)) continue;
            this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)value, invocation, cubeManager);
        }
    }

    private void checkParameterInstance(Object obj, Parameter parameter, OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        block42: {
            if (parameter instanceof LeafParameter) {
                LeafParameter leaf = (LeafParameter)parameter;
                if (!leaf.getParameterType().isAssignableFrom(obj.getClass())) {
                    throw new InvalidInvocationException(invocation, String.format("Invalid %s parameter instance class. Found %s, expected %s ", parameter.getIdentifier(), obj.getClass(), ((LeafParameter)parameter).getParameterType()));
                }
                try {
                    ColumnMetadata meta;
                    ColumnMetadataParameter param;
                    if (leaf instanceof ExpressionParameter) {
                        if (!((ExpressionParameter)leaf).validate((Expression)obj)) {
                            ((Expression)obj).validate();
                        }
                    } else if (leaf instanceof MultivaluedStringParameter) {
                        MultivaluedStringParameter multi = (MultivaluedStringParameter)leaf;
                        String param2 = (String)obj;
                        if (!multi.validate(param2)) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", param2, multi.getAdmittedValues()));
                        }
                    } else if (leaf instanceof RegexpStringParameter) {
                        RegexpStringParameter reg = (RegexpStringParameter)leaf;
                        String param3 = (String)obj;
                        if (!reg.validate(param3)) {
                            throw new Exception(String.format("Passed argument %s doesn't match regexp constraint %s", param3, reg.getRegexp()));
                        }
                    } else if (leaf instanceof TDTypeValueParameter) {
                        TDTypeValueParameter param4 = (TDTypeValueParameter)leaf;
                        TDTypeValue value = (TDTypeValue)obj;
                        if (!param4.getAllowedDataTypes().contains(value.getReturnedDataType())) {
                            throw new Exception(String.format("Invalid data type %s, allowed types are : %s.", value.getReturnedDataType(), param4.getAllowedDataTypes()));
                        }
                    } else if (leaf instanceof TargetColumnParameter) {
                        ColumnReference ref = (ColumnReference)obj;
                        TargetColumnParameter param5 = (TargetColumnParameter)leaf;
                        Table table = this.getTable(invocation, ref.getTableId(), cubeManager);
                        if (!param5.getAllowedTableTypes().contains(table.getTableType())) {
                            throw new Exception(String.format("Invalid table type %s, allowed types are : %s.", table.getTableType().getName(), param5.getAllowedTableTypes()));
                        }
                        Column col = this.getColumn(invocation, ref.getColumnId(), table, cubeManager);
                        if (!param5.getAllowedColumnTypes().contains(col.getColumnType())) {
                            throw new Exception(String.format("Invalid column type %s, allowed types are : %s.", col.getColumnType().getName(), param5.getAllowedColumnTypes()));
                        }
                        DataType colDataType = col.getDataType();
                        if (!param5.getAllowedDataTypes().contains(colDataType)) {
                            throw new Exception(String.format("Invalid data type %s, allowed types are : %s.", colDataType, param5.getAllowedDataTypes()));
                        }
                    } else if (leaf instanceof TargetTableParameter) {
                        TableId tableId = (TableId)obj;
                        TargetTableParameter param6 = (TargetTableParameter)leaf;
                        Table table = this.getTable(invocation, tableId, cubeManager);
                        if (!param6.getAllowedTableTypes().contains(table.getTableType())) {
                            throw new Exception(String.format("Invalid table type %s, allowed types are : %s.", table.getTableType().getName(), param6.getAllowedTableTypes()));
                        }
                    } else if (leaf instanceof LocalizedTextChoiceParameter) {
                        ImmutableLocalizedText text = (ImmutableLocalizedText)obj;
                        LocalizedTextChoiceParameter param7 = (LocalizedTextChoiceParameter)leaf;
                        if (!param7.getLabelChoices().contains(text)) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", text, param7.getLabelChoices()));
                        }
                    } else if (leaf instanceof ColumnTypeParameter) {
                        ColumnType type = (ColumnType)obj;
                        ColumnTypeParameter param8 = (ColumnTypeParameter)leaf;
                        if (!param8.getAllowedColumnTypes().contains(type)) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", type, param8.getAllowedColumnTypes()));
                        }
                    } else if (leaf instanceof MapParameter) {
                        MapParameter param9 = (MapParameter)leaf;
                        Map map = (Map)obj;
                        if (!map.isEmpty()) {
                            for (Map.Entry entry : map.entrySet()) {
                                if (param9.getKeyInstanceType().isInstance(entry.getKey()) && param9.getValueInstanceType().isInstance(entry.getValue())) continue;
                                throw new Exception(String.format("Invalid types for Map Instance, required Map<%s,%s> ", param9.getKeyInstanceType(), param9.getValueInstanceType()));
                            }
                        }
                    } else if (leaf instanceof DataTypeParameter) {
                        boolean bl;
                        DataType type = (DataType)obj;
                        DataTypeParameter param10 = (DataTypeParameter)leaf;
                        boolean bl2 = false;
                        for (DataType allowed : param10.getAllowedDataTypes()) {
                            if (!type.getClass().equals(allowed.getClass())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", type, param10.getAllowedDataTypes()));
                        }
                    } else if (leaf instanceof ColumnMetadataParameter && !(param = (ColumnMetadataParameter)leaf).isObjectValid((Object)(meta = (ColumnMetadata)obj))) {
                        throw new Exception(String.format("Passed argument %s is not among valid ones %s ", meta, param.getAllowedClasses()));
                    }
                    break block42;
                }
                catch (Exception e) {
                    throw new InvalidInvocationException(invocation, String.format("Parameter %s is invalid. Failure cause : %s ", parameter.getIdentifier(), e.getMessage()));
                }
            }
            if (parameter instanceof CompositeParameter) {
                try {
                    Map map = (Map)obj;
                }
                catch (Exception e) {
                    throw new InvalidInvocationException(invocation, String.format("Parameter %s must implement Map<String,Object>", parameter.getIdentifier()));
                }
            }
        }
    }

    protected void performBaseChecks(OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        if (invocation == null) {
            throw new InvalidInvocationException(invocation, "Operation invocation cannot be null");
        }
        if (invocation.getParameterInstances() == null) {
            throw new InvalidInvocationException(invocation, "Paramater map cannot be null");
        }
        switch (this.getOperationScope()) {
            case COLUMN: {
                Table table = this.getTable(invocation, invocation.getTargetTableId(), cubeManager);
                Column col = this.getColumn(invocation, invocation.getTargetColumnId(), table, cubeManager);
                ColumnScopedWorkerFactory thisColumnScoped = (ColumnScopedWorkerFactory)this;
                if (!thisColumnScoped.getAllowedColumnTypes().isEmpty() && !thisColumnScoped.getAllowedColumnTypes().contains(col.getColumnType())) {
                    throw new InvalidInvocationException(invocation, "target column type not accepted");
                }
                if (thisColumnScoped.getAllowedTableTypes().isEmpty() || thisColumnScoped.getAllowedTableTypes().contains(table.getTableType())) break;
                throw new InvalidInvocationException(invocation, "target table type not accepted");
            }
            case TABLE: {
                Table tab = this.getTable(invocation, invocation.getTargetTableId(), cubeManager);
                TableScopedWorkerFactory thisTableScoped = (TableScopedWorkerFactory)this;
                if (thisTableScoped.getAllowedTableTypes().isEmpty() || thisTableScoped.getAllowedTableTypes().contains(tab.getTableType())) break;
                throw new InvalidInvocationException(invocation, "target table type not accepted");
            }
        }
        this.checkParameters(this.getParameters(), invocation.getParameterInstances(), invocation, cubeManager);
    }

    private Column getColumn(OperationInvocation invocation, ColumnLocalId colId, Table table, CubeManager cubeManager) throws InvalidInvocationException {
        if (colId == null) {
            throw new InvalidInvocationException(invocation, "Column id cannot be null");
        }
        try {
            return table.getColumnById(colId);
        }
        catch (NoSuchColumnException e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    private Table getTable(OperationInvocation invocation, TableId tableId, CubeManager cubeManager) throws InvalidInvocationException {
        if (tableId == null) {
            throw new InvalidInvocationException(invocation, "Table id cannot be null");
        }
        try {
            return cubeManager.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    @Override
    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        return this.getOperationDescription();
    }
}

