/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;

public class ValidationHelper {
    public static GlobalDataValidationReportMetadata createDataValidationReport(Column validationColumn) {
        LocalizedText name = ((NamesMetadata)validationColumn.getMetadata(NamesMetadata.class)).getTextWithLocale(Locales.getDefaultLocale());
        DataValidationMetadata dataMeta = (DataValidationMetadata)validationColumn.getMetadata(DataValidationMetadata.class);
        return new GlobalDataValidationReportMetadata((LocalizedText)new ImmutableLocalizedText(dataMeta.getDescription()), name, dataMeta.getInvalidRowsCount(), validationColumn.getLocalId());
    }

    public static int getErrorCount(DatabaseConnectionProvider connectionProvider, Table targetTable, Column validationColumn, SQLExpressionEvaluatorFactory evaluatorFactory) throws EvaluatorException, SQLException {
        return SQLHelper.getCount(connectionProvider, targetTable.getName(), (String)evaluatorFactory.getEvaluator((Expression)new Equals((Expression)targetTable.getColumnReference(validationColumn), (Expression)new TDBoolean(false))).evaluate());
    }
}

