/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.factories.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.ImmutableOperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.ColumnScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.TableScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetTableParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public abstract class BaseWorkerFactory<T extends Worker<?>>
implements WorkerFactory<T> {
    protected abstract String getOperationName();

    protected abstract String getOperationDescription();

    protected OperationId getOperationId() {
        return new OperationId(this.getClass());
    }

    @Override
    @Deprecated
    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, WorkerFactory<ValidationWorker>> getPreconditionValidationMap() {
        if (this.getPrecoditionValidations().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, WorkerFactory<ValidationWorker>> preconds = new HashMap<String, WorkerFactory<ValidationWorker>>();
        for (WorkerFactory<ValidationWorker> factory : this.getPrecoditionValidations()) {
            preconds.put(factory.getOperationDescriptor().getName(), factory);
        }
        return preconds;
    }

    @Override
    public Map<String, Object> getParametersForPrecondion(String identifier, TableId tableId, ColumnLocalId columnId, Map<String, Object> sourceParameterInstance) throws InvalidInvocationException {
        return sourceParameterInstance;
    }

    @Override
    public boolean isRollbackable() {
        return false;
    }

    @Override
    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        throw new UnsupportedOperationException();
    }

    protected abstract OperationScope getOperationScope();

    protected abstract OperationType getOperationType();

    @Override
    public OperationDescriptor getOperationDescriptor() {
        return new ImmutableOperationDescriptor(this.getOperationId(), this.getOperationName(), this.getOperationDescription(), this.getOperationScope(), this.getOperationType(), this.getParameters());
    }

    protected abstract List<Parameter> getParameters();

    private void checkParameters(List<Parameter> toCheckParams, Map<String, Object> paramInstances, OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        for (Parameter parameter : toCheckParams) {
            if (paramInstances.containsKey(parameter.getIdentifier()) && paramInstances.get(parameter.getIdentifier()) == null) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is null", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 0 && !paramInstances.containsKey(parameter.getIdentifier())) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 1 && !(paramInstances.get(parameter.getIdentifier()) instanceof List)) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s must be multiple", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMaximum() == 1 && paramInstances.get(parameter.getIdentifier()) instanceof List) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s cannot be multiple", parameter.getIdentifier()));
            }
            Object value = paramInstances.get(parameter.getIdentifier());
            if (value == null) continue;
            if (value instanceof List) {
                List asList = (List)value;
                if (asList.size() < parameter.getCardinality().getMinimum()) {
                    throw new InvalidInvocationException(invocation, String.format("Not enough %s parameter instances(found %s instances), minimum is %s ", parameter.getIdentifier(), asList.size(), parameter.getCardinality().getMinimum()));
                }
                if (asList.size() > parameter.getCardinality().getMaximum()) {
                    throw new InvalidInvocationException(invocation, String.format("Too many %s parameter instances(found %s instances), maximum is %s ", parameter.getIdentifier(), asList.size(), parameter.getCardinality().getMaximum()));
                }
                for (Object obj : asList) {
                    this.checkParameterInstance(obj, parameter, invocation, cubeManager);
                    if (!(parameter instanceof CompositeParameter)) continue;
                    this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)obj, invocation, cubeManager);
                }
                continue;
            }
            this.checkParameterInstance(value, parameter, invocation, cubeManager);
            if (!(parameter instanceof CompositeParameter)) continue;
            this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)value, invocation, cubeManager);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkParameterInstance(Object obj, Parameter parameter, OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        if (parameter instanceof LeafParameter) {
            LeafParameter leaf = (LeafParameter)parameter;
            try {
                leaf.validateValue(obj);
                if (leaf instanceof TargetTableParameter) {
                    TableId tableId = (TableId)obj;
                    TargetTableParameter param = (TargetTableParameter)leaf;
                    Table table = this.getTable(invocation, tableId, cubeManager);
                    boolean ok = false;
                    for (TableType type : param.getAllowedTableTypes()) {
                        if (!type.getClass().isInstance(table.getTableType())) continue;
                        ok = true;
                    }
                    if (ok) return;
                    throw new Exception(String.format("Invalid table type %s, allowed types are : %s.", table.getTableType().getName(), param.getAllowedTableTypes()));
                }
                if (!(leaf instanceof TargetColumnParameter)) return;
                ColumnReference ref = (ColumnReference)obj;
                TargetColumnParameter param = (TargetColumnParameter)leaf;
                Table table = this.getTable(invocation, ref.getTableId(), cubeManager);
                boolean ok = false;
                for (Object type : param.getAllowedTableTypes()) {
                    if (!type.getClass().isInstance(table.getTableType())) continue;
                    ok = true;
                }
                if (!ok) {
                    throw new Exception(String.format("Invalid table type %s, allowed types are : %s.", table.getTableType().getName(), param.getAllowedTableTypes()));
                }
                Column col = this.getColumn(invocation, ref.getColumnId(), table, cubeManager);
                ok = false;
                for (ColumnType type : param.getAllowedColumnTypes()) {
                    if (!type.getClass().isInstance(col.getColumnType())) continue;
                    ok = true;
                }
                if (!ok) {
                    throw new Exception(String.format("Invalid column type %s, allowed types are : %s.", col.getColumnType().getName(), param.getAllowedColumnTypes()));
                }
                DataType colDataType = col.getDataType();
                ok = false;
                for (DataType dataType : param.getAllowedDataTypes()) {
                    if (!dataType.getClass().isInstance(colDataType)) continue;
                    ok = true;
                }
                if (ok) return;
                throw new Exception(String.format("Invalid data type %s, allowed types are : %s.", colDataType, param.getAllowedDataTypes()));
            }
            catch (Exception e) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is invalid. Failure cause : %s ", parameter.getIdentifier(), e.getMessage()));
            }
        }
        if (!(parameter instanceof CompositeParameter)) return;
        try {
            Map leaf = (Map)obj;
            return;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, String.format("Parameter %s must implement Map<String,Object>", parameter.getIdentifier()));
        }
    }

    protected void performBaseChecks(OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        if (invocation == null) {
            throw new InvalidInvocationException(invocation, "Operation invocation cannot be null");
        }
        if (invocation.getParameterInstances() == null) {
            throw new InvalidInvocationException(invocation, "Paramater map cannot be null");
        }
        switch (this.getOperationScope()) {
            case COLUMN: {
                Table table = this.getTable(invocation, invocation.getTargetTableId(), cubeManager);
                Column col = this.getColumn(invocation, invocation.getTargetColumnId(), table, cubeManager);
                ColumnScopedWorkerFactory thisColumnScoped = (ColumnScopedWorkerFactory)this;
                if (!thisColumnScoped.getAllowedColumnTypes().isEmpty() && !thisColumnScoped.getAllowedColumnTypes().contains(col.getColumnType())) {
                    throw new InvalidInvocationException(invocation, "target column type not accepted");
                }
                if (thisColumnScoped.getAllowedTableTypes().isEmpty() || thisColumnScoped.getAllowedTableTypes().contains(table.getTableType())) break;
                throw new InvalidInvocationException(invocation, "target table type not accepted");
            }
            case TABLE: {
                Table tab = this.getTable(invocation, invocation.getTargetTableId(), cubeManager);
                TableScopedWorkerFactory thisTableScoped = (TableScopedWorkerFactory)this;
                if (thisTableScoped.getAllowedTableTypes().isEmpty() || thisTableScoped.getAllowedTableTypes().contains(tab.getTableType())) break;
                throw new InvalidInvocationException(invocation, "target table type not accepted");
            }
        }
        this.checkParameters(this.getParameters(), invocation.getParameterInstances(), invocation, cubeManager);
    }

    private Column getColumn(OperationInvocation invocation, ColumnLocalId colId, Table table, CubeManager cubeManager) throws InvalidInvocationException {
        if (colId == null) {
            throw new InvalidInvocationException(invocation, "Column id cannot be null");
        }
        try {
            return table.getColumnById(colId);
        }
        catch (NoSuchColumnException e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    private Table getTable(OperationInvocation invocation, TableId tableId, CubeManager cubeManager) throws InvalidInvocationException {
        if (tableId == null) {
            throw new InvalidInvocationException(invocation, "Table id cannot be null");
        }
        try {
            return cubeManager.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    @Override
    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        return this.getOperationDescription();
    }
}

