package org.gcube.data.analysis.tabulardata.operation.comet;

import java.util.Calendar;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.comet.MappingParser.ParserConfiguration;
import org.gcube.data.analysis.tabulardata.operation.comet.model.Rule;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableTableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.TableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCodelistMappingWorker extends ResourceCreatorWorker{

	private static final Logger log = LoggerFactory.getLogger(ImportCodelistMappingWorker.class);

	private CubeManager cubeManager;
	private DatabaseConnectionProvider connectionProvider;
	private SQLExpressionEvaluatorFactory evaluatorFactory;

	public ImportCodelistMappingWorker(OperationInvocation sourceInvocation,
			CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider,
			SQLExpressionEvaluatorFactory evaluatorFactory) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.evaluatorFactory = evaluatorFactory;
	}

	private Table targetCodelist;
	private Table previousVersionCodelist=null;
	private String mappingUri=null;


	@Override
	protected ResourceDescriptorResult execute() throws WorkerException {
		updateProgress(0.1f,"Initializing..");
		targetCodelist=cubeManager.getTable(getSourceInvocation().getTargetTableId());
		try{
			previousVersionCodelist=cubeManager.getTable(OperationHelper.getParameter(ImportCodeListMappingFactory.PREVIOUS_VERSION_CODELIST_PARAMETER, getSourceInvocation()));
		}catch(Exception e){
			log.debug("previous codelist has not been set");
		}
		
		mappingUri=OperationHelper.getParameter(ImportCodeListMappingFactory.URL_PARAMETER, getSourceInvocation());
		
		
	
		
		ParserConfiguration config=new ParserConfiguration(previousVersionCodelist, targetCodelist);
		try{
			updateProgress(0.3f,"Parsing mapping..");
			MappingParser parser=new MappingParser(config, evaluatorFactory, cubeManager, connectionProvider);
			parser.parse(mappingUri);
			TableResource res=new TableResource(parser.getRulesTable().getId());
			return new ImmutableTableResource(res, "Imported harmonization rules", Calendar.getInstance());
		}catch(Exception e){
			throw new WorkerException("Processing failed "+e.getMessage());
		}
	}

}
