package org.gcube.data.analysis.tabulardata.operation.comet.model;

import java.sql.PreparedStatement;
import java.util.Collections;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;

public class Rule {

	public static final String TO_CHANGE_VALUE_FIELD="to_change_value";
	public static final String TO_SET_VALUE_FIELD="to_set_value";
	public static final String REFERRED_CODELIST_COLUMN="referred_column";
	public static final String ENABLED="enabled";
	public static final String ID="id";
	public static final String TO_CHANGE_VALUE_DESCRIPTION="to_change_value_description";
	public static final String TO_SET_VALUE_DESCRIPTION="to_set_value_description";
	
	
	private TDTypeValue toChangeValue;
	
	private TDTypeValue toSetValue;

	private ColumnReference referredCodelistColumn;

	private Boolean enabled=true;
	
	private long id=0;
	
	private String toChangeValueDescription;
	
	private String toSetValueDescription;
	
	/**
	 * SET DATASET.TARGET_COLUMN=TO_CHANGE_VALUE WHERE DATASET.TARGET_COLUMN=TO_SET_VALUE  
	 *  
	 * @param toChangeValue
	 * @param toSetValue
	 */
	public Rule(TDTypeValue toChangeValue, TDTypeValue toSetValue,ColumnReference reference) {
		super();
		this.toChangeValue = toChangeValue;
		this.toSetValue = toSetValue;
		this.referredCodelistColumn=reference;
	}

	
	
	public Rule(TDTypeValue toChangeValue, TDTypeValue toSetValue,
			ColumnReference reference, Boolean enabled,
			String toChangeValueDescription, String toSetValueDescription) {
		super();
		this.toChangeValue = toChangeValue;
		this.toSetValue = toSetValue;
		this.referredCodelistColumn = reference;
		this.enabled = enabled;
		this.toChangeValueDescription = toChangeValueDescription;
		this.toSetValueDescription = toSetValueDescription;
	}



	/**
	 * @return the toChangeValue
	 */
	public TDTypeValue getToChangeValue() {
		return toChangeValue;
	}

	/**
	 * @param toChangeValue the toChangeValue to set
	 */
	public void setToChangeValue(TDTypeValue toChangeValue) {
		this.toChangeValue = toChangeValue;
	}

	/**
	 * @return the toSetValue
	 */
	public TDTypeValue getToSetValue() {
		return toSetValue;
	}

	/**
	 * @param toSetValue the toSetValue to set
	 */
	public void setToSetValue(TDTypeValue toSetValue) {
		this.toSetValue = toSetValue;
	}

	/**
	 * @return the referredCodelistColumn
	 */
	public ColumnReference getReferredCodelistColumn() {
		return referredCodelistColumn;
	}

	/**
	 * @param referredCodelistColumn the referredCodelistColumn to set
	 */
	public void setReferredCodelistColumn(ColumnReference referredCodelistColumn) {
		this.referredCodelistColumn = referredCodelistColumn;
	}

	/**
	 * @return the enabled
	 */
	public Boolean isEnabled() {
		return enabled;
	}

	/**
	 * @param enabled the enabled to set
	 */
	public void setEnabled(Boolean enabled) {
		this.enabled = enabled;
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * @return the toChangeValueDescription
	 */
	public String getToChangeValueDescription() {
		return toChangeValueDescription;
	}

	/**
	 * @param toChangeValueDescription the toChangeValueDescription to set
	 */
	public void setToChangeValueDescription(String toChangeValueDescription) {
		this.toChangeValueDescription = toChangeValueDescription;
	}

	/**
	 * @return the toSetValueDescription
	 */
	public String getToSetValueDescription() {
		return toSetValueDescription;
	}

	/**
	 * @param toSetValueDescription the toSetValueDescription to set
	 */
	public void setToSetValueDescription(String toSetValueDescription) {
		this.toSetValueDescription = toSetValueDescription;
	}
	
	
	public static Table createTable(CubeManager cubeManager){
		AttributeColumnFactory factory=new AttributeColumnFactory();
		Column toSetCol=factory.create(new TextType(), Collections.singletonList(((LocalizedText)new ImmutableLocalizedText("To set value"))));
		Column toChangeCol=factory.create(new TextType(), Collections.singletonList(((LocalizedText)new ImmutableLocalizedText("To change value"))));
		Column toSetColDesc=factory.create(new TextType(), Collections.singletonList(((LocalizedText)new ImmutableLocalizedText("To set value description"))));
		Column toChangeColDesc=factory.create(new TextType(), Collections.singletonList(((LocalizedText)new ImmutableLocalizedText("To change value description"))));
		Column enabledCol=factory.create(new BooleanType(), Collections.singletonList(((LocalizedText)new ImmutableLocalizedText("Enabled"))));
		Column referenceCol=factory.create(new TextType(), Collections.singletonList(((LocalizedText)new ImmutableLocalizedText("Referred column"))));
		
		
		toSetCol.setName(TO_SET_VALUE_FIELD);
		toChangeCol.setName(TO_CHANGE_VALUE_FIELD);
		toSetColDesc.setName(TO_SET_VALUE_DESCRIPTION);
		toChangeColDesc.setName(TO_CHANGE_VALUE_DESCRIPTION);
		enabledCol.setName(ENABLED);
		referenceCol.setName(REFERRED_CODELIST_COLUMN);
		
		return cubeManager.createTable(new GenericTableType()).addColumns(
				toSetCol,
				toChangeCol,
				toSetColDesc,
				toChangeColDesc,
				enabledCol,
				referenceCol).create();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return String.format("col %s, %b  : FROM %s TO %s ",
				getReferredCodelistColumn(),
				isEnabled(),
				getToChangeValueDescription(),
				getToSetValueDescription());
	}
	
	
	
}
