package org.gcube.data.analysis.tabulardata.operation.comet.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import org.fao.fi.comet.mapping.model.MappingElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MappedRow extends HashMap<String,String>{

	private static Logger logger = LoggerFactory.getLogger(MappedRow.class);

	private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

	private static final String COTRIX_PREFIX="{http://cotrix.org}";
	private static final String DATE_FIELD=COTRIX_PREFIX+"updated";

	/**
	 * 
	 */
	private static final long serialVersionUID = -8270722918248713285L;
	/**
	 * 		Label1.1		Label2.1			Label3.1		....	Labelm.1
	 * 		Label1.2		Label2.2			Label3.2
	 * 		....			
	 * 		Label1.n		Label2.n			Label3.n		.... 	Labelm.n
	 * 
	 * 		---------------------------------------------------------------------
	 * 
	 * 		Value1			Value2				Value3			.....	Valuem
	 */


	public String id;
	public Date updated;

	public MappedRow(MappingElement element) {
		super();
		id=element.getId().getElementId().toString();
		NodeList list=element.getData().getElementsByTagName("Property");
		for(int i=0;i<list.getLength();i++){
			Element propElement=(Element) list.item(i);
			try{
				String name=propElement.getAttribute("name");
				String type=propElement.getAttribute("type");
				String value=propElement.getAttribute("value");
				if(name.startsWith(COTRIX_PREFIX))
					try{
						if(name.equals(DATE_FIELD)) updated=formatter.parse(value);
					}catch(Exception e){
						logger.debug(String.format("Unable to parse field %s [%s] = %s : %s",name,type,value,e.getMessage()));
					}
				else this.put(name, value);
			}catch(Throwable t){
				logger.debug("Unable to parse property "+propElement,t);
			}
		}
	}

	public String getId() {
		return id;
	}

	public Date getUpdated() {
		return updated;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("MappedRow [id=");
		builder.append(id);
		builder.append(", updated=");
		builder.append(updated);
		builder.append(", entrySet()=");
		builder.append(entrySet());
		builder.append("]");
		return builder.toString();
	}
	
	
}
