/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.comet;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.comet.ImportCodelistMappingWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableMetadataWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ImportCodeListMappingFactory
extends TableMetadataWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(12001L);
    private static final Logger logger = LoggerFactory.getLogger(ImportCodeListMappingFactory.class);
    public static RegexpStringParameter URL_PARAMETER = new RegexpStringParameter("url", "Document URL", "URL that points to a location where the document can be downloaded.", Cardinality.ONE, ".*");
    public static TargetColumnParameter PREVIOUS_VERSION_CODELIST_PARAMETER = new TargetColumnParameter("old_codes", "Code column before curation", "The code column of the previous version of this codelist, from which the mapping is generated", Cardinality.ONE);
    private static final List<Parameter> parameters = Arrays.asList(URL_PARAMETER, PREVIOUS_VERSION_CODELIST_PARAMETER);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;

    @Inject
    public ImportCodeListMappingFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
    }

    public MetadataWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        String mappingId = (String)OperationHelper.getParameter((LeafParameter)URL_PARAMETER, (Map)arg0.getParameterInstances());
        try {
            ImportCodeListMappingFactory.getInputStreamById(mappingId);
        }
        catch (Exception e) {
            logger.debug("Incorrect uri : " + mappingId, (Throwable)e);
            throw new InvalidInvocationException(arg0, "Invalid smp id " + mappingId);
        }
        return new ImportCodelistMappingWorker(arg0, this.cubeManager, this.connectionProvider, this.evaluatorFactory);
    }

    static InputStream getInputStreamById(String smpID) throws Exception {
        StorageClient client = new StorageClient(ImportCodeListMappingFactory.class.getName(), ImportCodeListMappingFactory.class.getSimpleName(), ImportCodeListMappingFactory.class.getName(), AccessType.PUBLIC);
        IClient icClient = client.getClient();
        return icClient.get().RFileAsInputStream(smpID);
    }

    protected String getOperationDescription() {
        return "Imports a comet file and infers harmonization rules.";
    }

    protected String getOperationName() {
        return "Import comet mapping";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationType getOperationType() {
        return OperationType.RESOURCECREATOR;
    }

    public OperationId getOperationId() {
        return OPERATION_ID;
    }
}

