/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.csv.importer.InitializerProcessor;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImport
extends BaseWorker {
    private static Logger logger = LoggerFactory.getLogger(CSVImport.class);
    private String encoding;
    private Character separator;
    private Boolean hasHeader;
    private String url;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    public CSVImport(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.retrieveParameters();
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public void run() {
        Table table;
        InitializerProcessor initializerProcessor;
        File csvFile;
        logger.trace("starting import CSV");
        this.inProgress(0.0f);
        try {
            csvFile = this.getInputFile(this.url);
        }
        catch (Exception e) {
            this.fail(new OperationException("failed downloading csv file", (Throwable)e));
            return;
        }
        this.inProgress(0.3f);
        try {
            initializerProcessor = this.getInitializerProcessor(csvFile);
        }
        catch (Exception e) {
            this.fail(new OperationException("failed reading csv header", (Throwable)e));
            return;
        }
        this.inProgress(0.5f);
        try {
            table = this.createTable(initializerProcessor.getColumns());
        }
        catch (Exception e) {
            this.fail(new OperationException("failed creating table", (Throwable)e));
            return;
        }
        this.inProgress(0.6f);
        try {
            this.copy(csvFile, table);
        }
        catch (Exception e) {
            this.fail(new OperationException("failed copying lines to table", (Throwable)e));
            return;
        }
        this.inProgress(1.0f);
        this.succeed(table);
        logger.trace("finished import CSV");
    }

    private Table createTable(List<Column> columns) throws Exception {
        TableCreator tableCreator = this.cubeManager.createTable((TableType)new GenericTableType());
        for (Column column : columns) {
            tableCreator.addColumn(column);
        }
        return tableCreator.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitializerProcessor getInitializerProcessor(File csvFile) throws Exception {
        InitializerProcessor initializer = new InitializerProcessor();
        CSVReaderProcessor csvReaderProcessor = new CSVReaderProcessor();
        csvReaderProcessor.setDelimiter(this.separator.charValue());
        csvReaderProcessor.setHasHeader(this.hasHeader.booleanValue());
        InputStreamReader isrInitializer = null;
        try {
            isrInitializer = new InputStreamReader((InputStream)new FileInputStream(csvFile), this.encoding);
            new CSVReaderProcessor().processStream((Reader)isrInitializer, (CSVLineProcessor)initializer);
            InitializerProcessor initializerProcessor = initializer;
            return initializerProcessor;
        }
        finally {
            if (isrInitializer != null) {
                isrInitializer.close();
            }
        }
    }

    private File getInputFile(String storageUrl) throws Exception {
        URL url = new URL(storageUrl);
        InputStream inputStream = url.openConnection().getInputStream();
        File tempFile = File.createTempFile("import", ".csv");
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            ((OutputStream)outputStream).write(bytes, 0, read);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copy(File csvFile, Table table) throws Exception {
        PGConnection conn = this.connectionProvider.getPostgreSQLConnection();
        CopyManager cpManager = conn.getCopyAPI();
        StringBuilder columns = new StringBuilder();
        for (Column c : table.getColumns()) {
            if (c.getColumnType() instanceof IdColumnType) continue;
            columns.append(c.getName() + ",");
        }
        columns.deleteCharAt(columns.length() - 1);
        String sqlCmd = String.format("COPY %s ( %s ) FROM STDIN ( FORMAT CSV ,DELIMITER '%c', HEADER %b, ENCODING '%s');", table.getName(), columns.toString(), this.separator, this.hasHeader, this.encoding);
        logger.info("executing copy for csv import with query {}", (Object)sqlCmd);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(csvFile), this.encoding);
            long lines = cpManager.copyIn(sqlCmd, (Reader)inputStreamReader);
            inputStreamReader.close();
            long l = lines;
            return l;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
    }

    private void retrieveParameters() {
        Map parameters = this.invocation.getParameterInstances();
        this.url = (String)parameters.get("url");
        this.separator = Character.valueOf(((String)parameters.get("separator")).charAt(0));
        this.hasHeader = (Boolean)parameters.get("hasHeader");
        this.encoding = (String)parameters.get("encoding");
    }
}

