/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.exporter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.csv.exporter.CSVExport;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

public class CSVExportFactory
extends ExportWorkerFactory {
    private static final OperationDescriptor.OperationId OPERATION_ID = new OperationDescriptor.OperationId(201L);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private static RegexpStringParameter separatorParameter = new RegexpStringParameter("separator", "Separator", "Char separator", Cardinality.ONE, "\\W");
    private static RegexpStringParameter encodingParameter = new RegexpStringParameter("encoding", "Encoding", "Document Encoding", Cardinality.ONE, ".*");

    @Inject
    public CSVExportFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        if (cubeManager == null) {
            throw new IllegalArgumentException("cubeManager cannot be null");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider cannot be null");
        }
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public EligibleOperation getEligibleOperation(TableId tableId) throws OperationNotEligibleException {
        return new EligibleOperation(this.getOperationDescriptor(), this.getParameters(tableId), tableId);
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.validateInvocation(invocation);
        return new CSVExport(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return "CSV Export";
    }

    protected String getOperationDescription() {
        return "Export a table to a CSV file";
    }

    protected OperationDescriptor.OperationId getOperationId() {
        return OPERATION_ID;
    }

    private List<Parameter> getParameters(TableId tableId) {
        ArrayList parameters = Lists.newArrayList();
        Collections.addAll(parameters, separatorParameter, encodingParameter);
        Table table = this.cubeManager.getTable(tableId);
        for (Column column : table.getColumns()) {
            if (column.getColumnType() instanceof IdColumnType) continue;
            String label = column.getName();
            try {
                NamesMetadata metadata = (NamesMetadata)column.getMetadata(NamesMetadata.class);
                if (metadata.hasTextWithLocale(Locale.ENGLISH)) {
                    label = metadata.getTextWithLocale(Locale.ENGLISH).getValue();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            parameters.add(new BooleanParameter(column.getName(), "column " + label + " export", "export selection for column " + label, Cardinality.ONE));
        }
        return parameters;
    }

    public void validateInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation == null) {
            throw new InvalidInvocationException(invocation, "null invocation");
        }
        this.checkTableIdPresence(invocation);
        if (!encodingParameter.validate((String)invocation.getParameterInstances().get("encoding"))) {
            throw new InvalidInvocationException(invocation, "encoding not valid");
        }
        if (!separatorParameter.validate((String)invocation.getParameterInstances().get("separator"))) {
            throw new InvalidInvocationException(invocation, "separator not valid");
        }
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        for (Column column : table.getColumns()) {
            if (column.getColumnType() instanceof IdColumnType || invocation.getParameterInstances().containsKey(column.getName())) continue;
            throw new InvalidInvocationException(invocation, String.format("column %s not found", column.getName()));
        }
    }
}

