/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExport
extends BaseWorker {
    private static Logger logger = LoggerFactory.getLogger(CSVExport.class);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private String encoding;
    private Character separator;

    public CSVExport(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.retrieveParameters();
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public void run() {
        String url;
        File exportFile;
        this.inProgress(0.0f);
        Table table = this.cubeManager.getTable(this.invocation.getTargetTableId());
        this.inProgress(0.1f);
        try {
            exportFile = File.createTempFile("export", ".csv");
        }
        catch (Exception e) {
            logger.error("error creating file", (Throwable)e);
            this.fail(new OperationException("error creating file", (Throwable)e));
            return;
        }
        this.inProgress(0.3f);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(exportFile));
            this.copy(outputStreamWriter, table, this.invocation.getParameterInstances());
        }
        catch (Exception e) {
            logger.error("error copying table to file", (Throwable)e);
            exportFile.delete();
            this.fail(new OperationException("error copying table to file", (Throwable)e));
            return;
        }
        this.inProgress(0.7f);
        try {
            url = this.storeFile(exportFile);
        }
        catch (Exception e) {
            logger.error("error storing file", (Throwable)e);
            exportFile.delete();
            this.fail(new OperationException("error storing file", (Throwable)e));
            return;
        }
        this.inProgress(0.9f);
        Table returnTable = this.createMetaTable(table, url);
        this.succeed(returnTable);
    }

    private String storeFile(File exportFile) {
        IClient client = new StorageClient("DataAnalysis", "TabularData", "CSVExport", AccessType.SHARED, MemoryType.VOLATILE).getClient();
        String remotePath = "/CSVexport/" + exportFile.getName();
        client.put(true).LFile(exportFile.getAbsolutePath()).RFile(remotePath);
        return client.getUrl().RFile(remotePath);
    }

    private Table createMetaTable(Table table, String url) {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(table.getId());
        tmc.setTableMetadata(new TableMetadata[]{new ExportMetadata("CSV", url, new Date())});
        return tmc.create();
    }

    private long copy(OutputStreamWriter outputStreamWriter, Table table, Map<String, Object> parameters) throws Exception {
        PGConnection conn = this.connectionProvider.getPostgreSQLConnection();
        CopyManager cpManager = conn.getCopyAPI();
        StringBuilder columns = new StringBuilder("SELECT ");
        for (Column c : table.getColumns()) {
            if (!parameters.containsKey(c.getName()) || !((Boolean)parameters.get(c.getName())).booleanValue()) continue;
            String label = c.getName();
            try {
                NamesMetadata metadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                if (metadata.hasTextWithLocale(Locale.ENGLISH)) {
                    label = metadata.getTextWithLocale(Locale.ENGLISH).getValue();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            columns.append(c.getName()).append(" as ").append(String.format("\"%s\"", label));
            columns.append(",");
        }
        columns.deleteCharAt(columns.length() - 1);
        columns.append(" from " + table.getName());
        String sqlCmd = String.format("COPY ( %s ) TO STDOUT ( FORMAT CSV ,DELIMITER '%c', HEADER %b, ENCODING '%s');", columns.toString(), this.separator, true, this.encoding);
        logger.info("executing copy for csv import with query {}", (Object)sqlCmd);
        return cpManager.copyOut(sqlCmd, (Writer)outputStreamWriter);
    }

    private void retrieveParameters() {
        Map parameters = this.invocation.getParameterInstances();
        this.separator = (Character)parameters.get("separator");
        this.encoding = (String)parameters.get("encoding");
    }
}

