/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.importer;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.csv.importer.CSVImport;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ImportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class CSVImportFactory
extends ImportWorkerFactory {
    private static final List<Parameter> parameters = Lists.newArrayList();
    private static OperationId operationId = new OperationId(100L);
    private static RegexpStringParameter urlParameter = new RegexpStringParameter("url", "Document URL", "URL that points to a location where the document can be downloaded.", Cardinality.ONE, ".*");
    private static RegexpStringParameter separatorParameter = new RegexpStringParameter("separator", "Separator", "Char separator as string", Cardinality.ONE, "^\\W$");
    private static RegexpStringParameter encodingParameter = new RegexpStringParameter("encoding", "Encoding", "Document Encoding", Cardinality.ONE, ".*");
    private static BooleanParameter booleanParameter = new BooleanParameter("hasHeader", "Header", "Tells if the document has header or not", Cardinality.ONE);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    @Inject
    public CSVImportFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        if (cubeManager == null) {
            throw new IllegalArgumentException("cubeManager cannot be null");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider cannot be null");
        }
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.validateInvocation(invocation);
        return new CSVImport(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return "CSV Import";
    }

    protected String getOperationDescription() {
        return "Create a new table with a CSV file";
    }

    protected OperationId getOperationId() {
        return operationId;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    public void validateInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation == null) {
            throw new InvalidInvocationException(invocation, "null invocation");
        }
        if (invocation.getParameterInstances() == null) {
            throw new InvalidInvocationException(invocation, "no parameters isntace are set");
        }
        if (!encodingParameter.validate((String)invocation.getParameterInstances().get("encoding"))) {
            throw new InvalidInvocationException(invocation, "encoding not valid");
        }
        if (!separatorParameter.validate((String)invocation.getParameterInstances().get("separator"))) {
            throw new InvalidInvocationException(invocation, "separator not valid");
        }
        if (!urlParameter.validate((String)invocation.getParameterInstances().get("url"))) {
            throw new InvalidInvocationException(invocation, "url not valid");
        }
    }

    static {
        parameters.add((Parameter)urlParameter);
        parameters.add((Parameter)separatorParameter);
        parameters.add((Parameter)encodingParameter);
        parameters.add((Parameter)booleanParameter);
    }
}

