package org.gcube.data.analysis.tabulardata.operation.csv.importer;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.csv4j.CSVLineProcessor;

public class InitializerProcessor implements CSVLineProcessor {
	
	private Logger logger = LoggerFactory.getLogger(InitializerProcessor.class);
	
	private boolean tableCreated = false;
	
	private int rows = 0;
	
	private List<Column> columns = new ArrayList<Column>();
	
	public void processHeaderLine(int lineNumber, List<String> fields) {
		this.onHeaderLine(lineNumber, fields);
	}

	public void processDataLine(int lineNumber, List<String> fields) {
		this.onDataLine(lineNumber, fields);
	}

	public boolean continueProcessing() {
		return !tableCreated;
	}

	public void onHeaderLine(int lineNumber, List<String> fields) {
		try{
			//creating the others fields
			for (int i=0; i<fields.size(); i++){
				//logger.debug("the max for field"+(k)+" is "+fields.size());
				Column column = null;
				if (fields!=null && fields.get(i)!="") column = AttributeColumnFactory.create(new ImmutableLocalizedText(fields.get(i)), new TextType()); 
				else column = AttributeColumnFactory.create(new ImmutableLocalizedText("field"+i), new TextType()); 
				columns.add(column);
			}
			tableCreated=true;
		}catch (Exception e) {
			logger.error("erorr reading the header line",e);
		}
	}

	
	public void onDataLine(int lineNumber, List<String> fields) {
		if (!tableCreated)
			try{

				for (int i=0; i<fields.size(); i++){
					//logger.debug("the max for field"+(k)+" is "+fields.size());
					Column column = AttributeColumnFactory.create(new ImmutableLocalizedText("field"+i), new TextType()); 
					columns.add(column);
				}
				tableCreated=true;
			}catch (Exception e) {
				logger.error("error reading data line", e);
			}
	}

	public int getRows() {
		return rows;
	}

	public List<Column> getColumns() {
		return columns;
	}
	
}
