/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.exporter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.csv.exporter.CSVExport;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public class CSVExportFactory
extends ExportWorkerFactory {
    private static final String OPERATION_NAME = "CSV Export";
    private static final OperationId OPERATION_ID = new OperationId(101L);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private static RegexpStringParameter separatorParameter = new RegexpStringParameter("separator", "Separator", "Char separator", Cardinality.ONE, "\\W$");
    private static RegexpStringParameter encodingParameter = new RegexpStringParameter("encoding", "Encoding", "Document Encoding", Cardinality.ONE, ".*");
    private static RegexpStringParameter columnsParameter = new RegexpStringParameter("columns", "Columns", "Selected Columns", new Cardinality(1, 1000), ".*");

    @Inject
    public CSVExportFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        if (cubeManager == null) {
            throw new IllegalArgumentException("cubeManager cannot be null");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider cannot be null");
        }
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.validateInvocation(invocation);
        return new CSVExport(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }

    protected String getOperationDescription() {
        return "Export a table to a CSV file";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<Parameter> getParameters() {
        ArrayList parameters = Lists.newArrayList();
        Collections.addAll(parameters, separatorParameter, encodingParameter, columnsParameter);
        return parameters;
    }

    public void validateInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation == null) {
            throw new InvalidInvocationException(invocation, "null invocation");
        }
        if (!encodingParameter.validate((String)invocation.getParameterInstances().get("encoding"))) {
            throw new InvalidInvocationException(invocation, "encoding not valid");
        }
        if (!separatorParameter.validate((String)invocation.getParameterInstances().get("separator"))) {
            throw new InvalidInvocationException(invocation, "separator not valid");
        }
        String[] columns = (String[])invocation.getParameterInstances().get("columns");
        if (columns == null || columns.length <= 0) {
            throw new InvalidInvocationException(invocation, "columns parameter not valid");
        }
    }
}

