/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.importer;

import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializerProcessor
implements CSVLineProcessor {
    private Logger logger = LoggerFactory.getLogger(InitializerProcessor.class);
    private boolean tableCreated = false;
    private int rows = 0;
    private List<Column> columns = new ArrayList<Column>();

    public void processHeaderLine(int lineNumber, List<String> fields) {
        this.onHeaderLine(lineNumber, fields);
    }

    public void processDataLine(int lineNumber, List<String> fields) {
        this.onDataLine(lineNumber, fields);
    }

    public boolean continueProcessing() {
        return !this.tableCreated;
    }

    public void onHeaderLine(int lineNumber, List<String> fields) {
        try {
            for (int i = 0; i < fields.size(); ++i) {
                Column column = null;
                column = fields != null && fields.get(i) != "" ? AttributeColumnFactory.create((LocalizedText)new ImmutableLocalizedText(fields.get(i)), (DataType)new TextType()) : AttributeColumnFactory.create((LocalizedText)new ImmutableLocalizedText("field" + i), (DataType)new TextType());
                this.columns.add(column);
            }
            this.tableCreated = true;
        }
        catch (Exception e) {
            this.logger.error("erorr reading the header line", (Throwable)e);
        }
    }

    public void onDataLine(int lineNumber, List<String> fields) {
        if (!this.tableCreated) {
            try {
                for (int i = 0; i < fields.size(); ++i) {
                    Column column = AttributeColumnFactory.create((LocalizedText)new ImmutableLocalizedText("field" + i), (DataType)new TextType());
                    this.columns.add(column);
                }
                this.tableCreated = true;
            }
            catch (Exception e) {
                this.logger.error("error reading data line", (Throwable)e);
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    public List<Column> getColumns() {
        return this.columns;
    }
}

