/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.export.csv.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExport
extends ResourceCreatorWorker {
    private static Logger logger = LoggerFactory.getLogger(CSVExport.class);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private String encoding;
    private String resourceName = "CsvExport";
    private String resourceDescription = "TabularResource exported in CSV";
    private Character separator;
    private List<String> selectedColumns;
    private boolean useView = false;

    public CSVExport(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.retrieveParameters();
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public ResourcesResult execute() throws WorkerException {
        InternalURI internalURI;
        File exportFile;
        logger.trace("STARTING EXPORT");
        Table table = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.1f, "Creating export file");
        try {
            exportFile = File.createTempFile("export", ".csv");
        }
        catch (Exception e) {
            logger.error("error creating file", (Throwable)e);
            throw new WorkerException("error creating file", (Throwable)e);
        }
        this.updateProgress(0.3f, "Writing file with data");
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(exportFile));
                long updated = this.copy(outputStreamWriter, table, this.getSourceInvocation().getParameterInstances());
                logger.debug("exported " + updated + " entries");
            }
            catch (Exception e) {
                logger.error("error copying table to file", (Throwable)e);
                exportFile.delete();
                throw new WorkerException("error copying table to file", (Throwable)e);
            }
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e) {
                    logger.warn("error closing output stream", (Throwable)e);
                }
            }
        }
        this.updateProgress(0.7f, "Storing file on storage");
        try {
            try {
                internalURI = this.getInternalURI(exportFile);
            }
            catch (Exception e) {
                logger.error("error storing file", (Throwable)e);
                throw new WorkerException("error storing file", (Throwable)new Exception(e.getMessage()));
            }
        }
        finally {
            exportFile.delete();
        }
        this.updateProgress(0.9f, "Finalizing");
        return new ResourcesResult(this.createDescriptor(internalURI));
    }

    private InternalURI getInternalURI(File exportFile) throws URISyntaxException {
        IClient client = Utils.getStorageClient();
        String remotePath = "/CSVexport/" + exportFile.getName();
        String id = client.put(true).LFile(exportFile.getAbsolutePath()).RFile(remotePath);
        return new InternalURI(new URI(id), "text/csv");
    }

    private ResourceDescriptorResult createDescriptor(InternalURI url) throws WorkerException {
        return new ImmutableURIResult(url, this.resourceName, this.resourceDescription, ResourceType.CSV);
    }

    private long copy(OutputStreamWriter outputStreamWriter, Table table, Map<String, Object> parameters) throws Exception {
        PGConnection conn = this.connectionProvider.getPostgreSQLConnection();
        CopyManager cpManager = conn.getCopyAPI();
        StringBuilder columns = new StringBuilder("SELECT ");
        Table toUseTable = table;
        if (this.useView && table.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
            toUseTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        for (Column c : table.getColumns()) {
            if (!this.selectedColumns.contains(c.getLocalId().getValue())) continue;
            Column toUseColumn = c;
            if (this.useView && c.getColumnType() instanceof DimensionColumnType) {
                ColumnLocalId columnTargetId = c.getRelationship().getTargetColumnId();
                toUseColumn = toUseTable.getColumnById(columnTargetId);
            } else {
                toUseColumn = toUseTable.getColumnById(c.getLocalId());
            }
            if (toUseColumn.getDataType() instanceof GeometryType) {
                columns.append("ST_AsText(").append(toUseColumn.getName()).append(")");
            } else {
                columns.append(toUseColumn.getName());
            }
            columns.append(" as ").append(String.format("\"%s\"", this.getColumnLabel(toUseColumn))).append(",");
        }
        columns.deleteCharAt(columns.length() - 1);
        columns.append(" from ").append(toUseTable.getName());
        String sqlCmd = String.format("COPY ( %s ) TO STDOUT ( FORMAT CSV ,DELIMITER '%c', HEADER %b, ENCODING '%s');", columns.toString(), this.separator, true, this.encoding);
        logger.info("executing copy for csv import with query {}", (Object)sqlCmd);
        return cpManager.copyOut(sqlCmd, (Writer)outputStreamWriter);
    }

    private String getColumnLabel(Column column) {
        String label = column.getName();
        try {
            NamesMetadata metadata = (NamesMetadata)column.getMetadata(NamesMetadata.class);
            if (metadata.hasTextWithLocale("en")) {
                label = metadata.getTextWithLocale("en").getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (label.isEmpty()) {
            label = column.getLocalId().getValue();
        }
        return label;
    }

    private void retrieveParameters() {
        Map parameters = this.getSourceInvocation().getParameterInstances();
        this.separator = Character.valueOf(((String)parameters.get("separator")).charAt(0));
        this.encoding = (String)parameters.get("encoding");
        this.selectedColumns = new ArrayList<String>();
        Object columnsParam = parameters.get("columns");
        if (columnsParam instanceof Iterable) {
            for (String col : (Iterable)columnsParam) {
                this.selectedColumns.add(col);
            }
        } else {
            this.selectedColumns.add((String)columnsParam);
        }
        if (parameters.containsKey("useView")) {
            this.useView = (Boolean)parameters.get("useView");
        }
        if (parameters.containsKey("name")) {
            this.resourceName = (String)parameters.get("name");
        }
        if (parameters.containsKey("description")) {
            this.resourceDescription = (String)parameters.get("description");
        }
    }
}

