package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

import com.google.common.collect.Lists;

@Singleton
public class DuplicateRowRemoverFactory extends TableTransformationWorkerFactory {
	
	private static final OperationId OPERATION_ID = new OperationId(3007);
	
	private CubeManager cubeManager;
	
	private DatabaseConnectionProvider connectionProvider;

	@Inject
	public DuplicateRowRemoverFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation);
		return new DuplicateRowRemover(invocation, cubeManager, connectionProvider);
	}

	@Override
	protected String getOperationName() {
		return "Remove duplicate tuples";
	}

	@Override
	protected String getOperationDescription() {
		return "Remove tuples that presents the same data";
	}

	@Override
	protected List<Parameter> getParameters() {
		return Lists.newArrayList(); 
	}

	@Override
	protected OperationId getOperationId() {		
		return OPERATION_ID;
	}
	
}
