package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.HashMap;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpression;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByExpression extends Worker {

	private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);

	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;

	private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;

	private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;
	private ValidateDataWithExpressionFactory validateDataWithExpressionFactory;
	
	public FilterByExpression(OperationInvocation sourceInvocation,
			CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider,
			SQLExpressionEvaluatorFactory sqlEvaluatorFactory,
			DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory,
			ValidateDataWithExpressionFactory validateDataWithExpressionFactory) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.sqlEvaluatorFactory = sqlEvaluatorFactory;
		this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
		this.validateDataWithExpressionFactory = validateDataWithExpressionFactory;
	}
	


	private Table targetTable;
	private Table evaluatedTable;
	private Table filteredTable;
	private Column validationColumn;
	private Expression filterCondition;
	private Expression deleteCondition;
	
	@Override
	protected WorkerResult execute() throws WorkerException {
		retrieveParameters();
		updateProgress(0.1f);
		executeValidation();
		updateProgress(0.3f);
		filteredTable=cubeManager.createTable(evaluatedTable.getTableType()).like(evaluatedTable, true).create();
		updateProgress(0.5f);
		filterValidatedTable();
		updateProgress(0.9f);				
		return new ImmutableWorkerResult(cubeManager.removeValidations(filteredTable.getId()));
	}

	private void retrieveParameters(){		
		filterCondition=(Expression) getSourceInvocation().getParameterInstances().get(FilterByExpressionFactory.EXPRESSION_PARAMETER.getIdentifier());
		targetTable=cubeManager.getTable(getSourceInvocation().getTargetTableId());		
	}
	
	private void executeValidation() throws WorkerException{
		WorkerWrapper wrapper=new WorkerWrapper(validateDataWithExpressionFactory);
		HashMap<String,Object> map=new HashMap<String,Object>();		
		map.put(validateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), filterCondition);
		try{
			WorkerStatus status=wrapper.execute(targetTable.getId(), null, map);
			if(!status.equals(WorkerStatus.SUCCEDED))
				throw new WorkerException("Wrapped step has failed, see previous log");	
			evaluatedTable=wrapper.getResult().getResultTable();
			log.debug("Evaluated table : "+evaluatedTable);
		}catch(InvalidInvocationException e){
			throw new WorkerException("Unable to check condition",e);
		}
	}
	
	private void filterValidatedTable() throws WorkerException{
		log.debug("Creating condition on validation column for table "+filteredTable);
		validationColumn = filteredTable.getColumnsByType(ValidationColumnType.class).get(0);
		deleteCondition=new Equals(filteredTable.getColumnReference(validationColumn),new TDBoolean(false));
		executeFilter();
	}
	
	private void executeFilter() throws WorkerException{
		try {
			String sqlCommand=String.format("DELETE FROM %s WHERE %s", filteredTable.getName(),sqlEvaluatorFactory.getEvaluator(deleteCondition).evaluate());			
			SQLHelper.executeSQLBatchCommands(connectionProvider, sqlCommand);
		} catch (Exception e) {
			throw new WorkerException("Error occurred while executing SQL command", e);
		}
	}
}
