/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.sql.SQLException;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class DuplicateRowRemover
extends Worker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    Table targetTable;
    Column targetColumn;
    Table newTable;

    public DuplicateRowRemover(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.createNewTable();
        this.updateProgress(0.5f);
        this.removeDuplicateTuples();
        return new ImmutableWorkerResult(this.newTable);
    }

    private void removeDuplicateTuples() throws WorkerException {
        String sql = this.generateSQLDeleteCommand();
        try {
            SQLHelper.executeSQLCommand((String)sql, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Error occurred while performing deletion of duplicate tuples", (Throwable)e);
        }
    }

    private String generateSQLDeleteCommand() {
        List columns = this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class});
        String columnsSnippet = SQLHelper.generateColumnNameSnippet((List)columns);
        return String.format("WITH dupHashes AS (\tSELECT md5(concat(%s)) AS hash \tFROM %s \tGROUP BY hash \tHAVING count(*) > 1), duplicateTuples AS (\tSELECT id, md5(concat(%1$s)) AS hash \tFROM %2$s \tWHERE md5(concat(%1$s)) IN (SELECT * from dupHashes)), toKeep AS (\tSELECT min(id) AS id, md5(concat(%1$s)) AS hash\tFROM %2$s\tWHERE md5(concat(%1$s)) IN (SELECT * from dupHashes)\tGROUP BY hash) DELETE FROM %2$s WHERE id IN (\tSELECT id FROM duplicateTuples EXCEPT (SELECT id FROM toKeep));", columnsSnippet, this.newTable.getName());
    }

    private void createNewTable() {
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
    }
}

