/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class DuplicateRowRemover
extends Worker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DuplicateRowValidatorFactory validatorFactory;
    Table targetTable;
    Table newTable;

    public DuplicateRowRemover(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DuplicateRowValidatorFactory validatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.validatorFactory = validatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.1f);
        this.executeValidation();
        this.updateProgress(0.3f);
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.updateProgress(0.5f);
        this.filterValidatedTable();
        this.updateProgress(0.9f);
        return new ImmutableWorkerResult(this.cubeManager.removeValidations(this.newTable.getId()));
    }

    private void filterValidatedTable() throws WorkerException {
        Column validationColumn = (Column)this.newTable.getColumnsByType(new Class[]{ValidationColumnType.class}).get(0);
        Equals deleteCondition = new Equals((Expression)this.newTable.getColumnReference(validationColumn), (Expression)new TDBoolean(false));
        this.executeFilter((Expression)deleteCondition);
    }

    private void executeFilter(Expression condition) throws WorkerException {
        try {
            String sqlCommand = String.format("DELETE FROM %s WHERE %s", this.newTable.getName(), this.sqlEvaluatorFactory.getEvaluator(condition).evaluate());
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{sqlCommand});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private void executeValidation() throws WorkerException {
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.validatorFactory);
        Map map = this.getSourceInvocation().getParameterInstances();
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, map);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Wrapped step has failed, see previous log");
            }
            this.targetTable = wrapper.getResult().getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to check condition", (Throwable)e);
        }
    }
}

