/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.AggregationFunction;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.GroupBy;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextChoiceParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class GroupByFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3006L);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;
    public static final TargetColumnParameter GROUPBY_COLUMNS = new TargetColumnParameter("groupByColumns", "Group By Columns", "Columns to use as a key of grouping", new Cardinality(1, Integer.MAX_VALUE), Arrays.asList(new CodelistTableType(), new DatasetTableType(), new DatasetViewTableType(), new GenericTableType(), new TimeCodelistTableType()), Arrays.asList(new AnnotationColumnType(), new AttributeColumnType(), new CodeColumnType(), new CodeDescriptionColumnType(), new CodeNameColumnType(), new DimensionColumnType(), new MeasureColumnType(), new TimeDimensionColumnType()));
    public static final LocalizedTextChoiceParameter FUNCTION_PARAMETER = new LocalizedTextChoiceParameter("functionParameter", "Function Parameter", "Aggregation function to apply", Cardinality.ONE, Arrays.asList(new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.AVG)), new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.COUNT)), new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.FIRST)), new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.LAST)), new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.MAX)), new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.MIN)), new ImmutableLocalizedText("" + (Object)((Object)AggregationFunction.SUM))));
    public static final TargetColumnParameter TO_AGGREGATE_COLUMNS = new TargetColumnParameter("functionMember", "To Aggregate values", "Aggregation function member", Cardinality.ONE, Arrays.asList(new CodelistTableType(), new DatasetTableType(), new DatasetViewTableType(), new GenericTableType(), new TimeCodelistTableType()), Arrays.asList(new AnnotationColumnType(), new AttributeColumnType(), new CodeColumnType(), new CodeDescriptionColumnType(), new CodeNameColumnType(), new DimensionColumnType(), new MeasureColumnType(), new TimeDimensionColumnType()));
    public static final CompositeParameter AGGREGATE_FUNCTION_TO_APPLY = new CompositeParameter("aggregationFunctions", "Aggregation Functions", "Aggregation Function to apply", new Cardinality(1, Integer.MAX_VALUE), Arrays.asList(FUNCTION_PARAMETER, TO_AGGREGATE_COLUMNS));
    private List<Parameter> parameters = Arrays.asList(GROUPBY_COLUMNS, AGGREGATE_FUNCTION_TO_APPLY);

    public Worker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0);
        this.checkParameters(arg0);
        return new GroupBy(arg0, this.cubeManager, this.connectionProvider, this.sqlExpressionEvaluatorFactory);
    }

    private void checkParameters(OperationInvocation invocation) throws InvalidInvocationException {
        TableId targetTableId = invocation.getTargetTableId();
        Object toAggregateObj = invocation.getParameterInstances().get(GROUPBY_COLUMNS.getIdentifier());
        if (toAggregateObj instanceof Iterable) {
            Iterable cols = (Iterable)toAggregateObj;
            for (ColumnReference ref : cols) {
                if (ref.getTableId().equals((Object)targetTableId)) continue;
                throw new InvalidInvocationException(invocation, "Inconsistent target table and aggregation column references");
            }
        } else if (!((ColumnReference)toAggregateObj).getTableId().equals((Object)targetTableId)) {
            throw new InvalidInvocationException(invocation, "Inconsistent target table and aggregation column references");
        }
        Object compositeObj = invocation.getParameterInstances().get(AGGREGATE_FUNCTION_TO_APPLY.getIdentifier());
        if (compositeObj instanceof Iterable) {
            for (Object mapObj : (Iterable)compositeObj) {
                if (((ColumnReference)((Map)mapObj).get(TO_AGGREGATE_COLUMNS.getIdentifier())).getTableId().equals((Object)targetTableId)) continue;
                throw new InvalidInvocationException(invocation, "Inconsistent target table and to aggregate values column references");
            }
        } else if (!((ColumnReference)((Map)compositeObj).get(TO_AGGREGATE_COLUMNS.getIdentifier())).getTableId().equals((Object)targetTableId)) {
            throw new InvalidInvocationException(invocation, "Inconsistent target table and to aggregate values column references");
        }
    }

    @Inject
    public GroupByFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
    }

    protected String getOperationDescription() {
        return "Aggregate selected columns values, applying the specified functions to relative selected member columns";
    }

    protected String getOperationName() {
        return "Aggregation";
    }

    protected List<Parameter> getParameters() {
        return this.parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

