package org.gcube.data.analysis.tabulardata.operation.data.add;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class AddColumn extends Worker {

	private CubeManager cubeManager;
	
	public AddColumn(OperationInvocation sourceInvocation,
			CubeManager cubeManager) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
	}


	private Table targetTable;
	private Column theNewColumn;
	

	@Override
	protected WorkerResult execute() throws WorkerException {
		targetTable=cubeManager.getTable(getSourceInvocation().getTargetTableId());
		theNewColumn=createColumn();
		Table resultTable=cubeManager.createTable(targetTable.getTableType()).like(targetTable, true).addColumn(theNewColumn).create();
		return new ImmutableWorkerResult(resultTable);
	}

	
	private Column createColumn(){
		return null;
	}
	
}
