package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class ExtractCodelistFactory extends ExportWorkerFactory{

	private static final OperationId OPERATION_ID = new OperationId(3006);
	
	public static TargetColumnParameter VALUES_SOURCE_COLUMN;
	
	public static TargetColumnParameter TARGET_CODE_COLUMN;
	
	
	private List<Parameter> parameters = Arrays.asList(new Parameter[]{
			VALUES_SOURCE_COLUMN,
			TARGET_CODE_COLUMN
	});
	
	
	static {
		ArrayList<Class<? extends TableType>> sourceTables=new ArrayList<>();
		sourceTables.add(CodelistTableType.class);
		sourceTables.add(DatasetTableType.class);
		sourceTables.add(DatasetViewTableType.class);
		sourceTables.add(GenericTableType.class);
		ArrayList<Class<? extends ColumnType>> sourceCols=new ArrayList<>();
		sourceCols.add(AnnotationColumnType.class);
		sourceCols.add(AttributeColumnType.class);
		sourceCols.add(CodeDescriptionColumnType.class);
		sourceCols.add(CodeNameColumnType.class);
		sourceCols.add(MeasureColumnType.class);
		
		VALUES_SOURCE_COLUMN=new TargetColumnParameter("value_source_column", "Values suorce column", "The column from which the codes are taken", Cardinality.ONE,
				sourceTables,sourceCols);
		
		ArrayList<Class<? extends TableType>> targetTables=new ArrayList<>();
		targetTables.add(CodelistTableType.class);
		ArrayList<Class<? extends ColumnType>> targetCols=new ArrayList<>();
		targetCols.add(CodeColumnType.class);
		
		TARGET_CODE_COLUMN=new TargetColumnParameter("target_code_column", "Target code column", "The code column to which exctracted values must be added", Cardinality.OPTIONAL, 
				targetTables,targetCols);
	}
	
	
	
	
	
	CubeManager cubeManager;
	
	DatabaseConnectionProvider connectionProvider;
	SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;
	
	@Inject
	public ExtractCodelistFactory(CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider,
			SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
		super();
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
	}
	
	@Override
	protected String getOperationDescription() {
		return "Extract distinct values from the target column and puts them in the selected codelist or a new one.";
	}
	
	@Override
	protected String getOperationName() {
		return "Extract codelist";
	}
	@Override
	protected OperationId getOperationId() {		
		return OPERATION_ID;
	}
	
	
	
	
	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}
	
	
	@Override
	public Worker createWorker(OperationInvocation invocation)
			throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		checkParametersValidity(invocation); 
		return new ExtractCodelist(invocation, cubeManager, connectionProvider);
	}
	
	private void checkParametersValidity(OperationInvocation invocation) throws InvalidInvocationException{
		ColumnReference ref=(ColumnReference) invocation.getParameterInstances().get(VALUES_SOURCE_COLUMN.getIdentifier());
		if(!ref.getTableId().equals(invocation.getTargetTableId())) throw new InvalidInvocationException(invocation,"Source column must belong to target table");
	}
	
}
